package com.yeejoin.amos.boot.module.jg.api.enums;

/**
 * 办理状态枚举
 */
public enum  FlowStatusEnum {

    /**
     * 待提交
     */
    TO_BE_SUBMITTED(6610, "待提交"),
    /**
     * 已提交
     */
    SUBMITTED(6611, "已提交"),
    /**
     * 待受理
     */
    TO_BE_PROCESSED(6612, "待受理"),
    /**
     * 已办理
     */
    HAVE_PROCESSED(6613, "已办理"),

    /**
     * 已驳回
     */
    REJECTED(6614, "已驳回"),

    /**
     * 已撤回
     */
    ROBACK(6615, "已撤回");

    private final int code;

    private final String name;

    FlowStatusEnum(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public static String getNameByType(Long code) {
        String name = null;
        for (FlowStatusEnum enumOne : FlowStatusEnum.values()) {
            if (enumOne.getCode() == code) {
                name = enumOne.getName();
                break;
            }
        }
        return name;
    }

    public int getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}
