package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.bo.CompanyBo;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.service.impl.DataDictionaryServiceImpl;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jg.api.mapper.CommonMapper;
import com.yeejoin.amos.boot.module.jg.biz.service.ICommonService;
import com.yeejoin.amos.boot.module.jg.flc.api.fegin.PrivilegeFeginService;
import com.yeejoin.amos.boot.module.ymt.api.entity.EquipmentCategory;
import com.yeejoin.amos.boot.module.ymt.api.mapper.EquipmentCategoryMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.IdxBizJgFactoryInfoMapper;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.component.feign.utils.FeignUtil;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.foundation.context.RequestContext;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 装备分类服务实现类
 *
 * @author system_generator
 * @date 2021-10-20
 */
@Service
@Slf4j
public class CommonServiceImpl implements ICommonService {

    @Autowired
    EquipmentCategoryMapper equipmentCategoryMapper;
    @Autowired
    private RedisUtils redisUtils;

    @Autowired
    CommonMapper commonMapper;

    //行政区划redis缓存key
    private static final String PROVINCE = "PROVINCE";
    private static final String CITY = "CITY";
    private static final String REGION = "REGION";
    private static final String STREET = "STREET";
    //行政区划level
    private static final String PROVINCE_LEVEL = "1";
    private static final String CITY_LEVEL = "2";
    private static final String REGION_LEVEL = "3";
    private static final String STREET_LEVEL = "4";

    //判断行政区划查询市还是区
    private static final String END_CODE = "0000";
    //判断行政区划查询街道
    private static final String STREET_END_CODE = "00";

    //管辖机构redis缓存key
    private static final String REGULATOR_UNIT_TREE = "REGULATOR_UNIT_TREE";

    @Value("${regulator.unit.code}")
    private String code;

    @Autowired
    PrivilegeFeginService privilegeFeginService;

    @Override
    public List<EquipmentCategory> getEquipmentCategoryList(String code, String type) {
        List<EquipmentCategory> result = new ArrayList<>();


        LambdaQueryWrapper<EquipmentCategory> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(EquipmentCategory::getCode, code);
        EquipmentCategory equipmentCategory = equipmentCategoryMapper.selectOne(wrapper);
        if (ObjectUtils.isEmpty(type)) {
            result.add(equipmentCategory);
        } else {
            LambdaQueryWrapper<EquipmentCategory> wrapper2 = new LambdaQueryWrapper<>();
            wrapper2.eq(EquipmentCategory::getParentId, equipmentCategory.getId());
            result = equipmentCategoryMapper.selectList(wrapper2);
        }
        return result;
    }

    @Override
    public List<LinkedHashMap> getRegion(String level, String parentId) {
        List<LinkedHashMap> list = new ArrayList<>();
        if (!ObjectUtils.isEmpty(level)) {
            list = (List<LinkedHashMap>) redisUtils.get(PROVINCE);
            return ObjectUtils.isEmpty(list) ? getProvinceList(level) : list;
        } else if (!ObjectUtils.isEmpty(parentId)) {
            String regionCode = parentId.split("_")[0];
            //regionCode不是以00结尾查询街道，以0000结果查询市、否则查询区
            if (!regionCode.endsWith(STREET_END_CODE)) {
                list = ObjectUtils.isEmpty(redisUtils.get(STREET)) ? getProvinceList(STREET_LEVEL) : (List<LinkedHashMap>) redisUtils.get(STREET);
            } else if (regionCode.endsWith(END_CODE)) {
                list = ObjectUtils.isEmpty(redisUtils.get(CITY)) ? getProvinceList(CITY_LEVEL) : (List<LinkedHashMap>) redisUtils.get(CITY);
            } else {
                list = ObjectUtils.isEmpty(redisUtils.get(REGION)) ? getProvinceList(REGION_LEVEL) : (List<LinkedHashMap>) redisUtils.get(REGION);
            }
            return list.stream().filter(r -> regionCode.equals(r.get("parentRegionCode").toString())).collect(Collectors.toList());
        } else {
            return new ArrayList<>();
        }
    }


    public List<LinkedHashMap> getProvinceList(String level) {
        FeignClientResult result = privilegeFeginService.getProvince(level);
        List<LinkedHashMap> list = (List<LinkedHashMap>) result.getResult();
        for (LinkedHashMap linkedHashMap : list) {
            linkedHashMap.put("sequenceNbr", linkedHashMap.get("regionCode"));
        }
        switch (level) {
            case PROVINCE_LEVEL:
                redisUtils.set(PROVINCE, list);
                break;
            case CITY_LEVEL:
                redisUtils.set(CITY, list);
                break;
            case REGION_LEVEL:
                redisUtils.set(REGION, list);
                break;
            case STREET_LEVEL:
                redisUtils.set(STREET, list);
                break;
            default:
                log.error("不支持的行政区划：{}", level);
                break;
        }
        return list;
    }


    @Override
    public List<LinkedHashMap> getTree() {
        List<LinkedHashMap> result = (List<LinkedHashMap>) redisUtils.get(REGULATOR_UNIT_TREE);
        //判断redis是否存在管辖机构树
        return !ObjectUtils.isEmpty(result) ? result : creatTree();
    }

    @Override
    public List<LinkedHashMap> creatTree() {
        FeignClientResult tree = privilegeFeginService.tree(RequestContext.getToken(), RequestContext.getAppKey(), RequestContext.getProduct());
        List<LinkedHashMap> result = (List<LinkedHashMap>) tree.getResult();
        List<LinkedHashMap> treeData = deleteRegulatorTreeData(result);
        List<LinkedHashMap> supervisionTree = treeData.stream().filter(e -> code.equals(e.get("orgCode"))).collect(Collectors.toList());
        List<LinkedHashMap> resultTree = updateNullChildren(supervisionTree);
        redisUtils.set(REGULATOR_UNIT_TREE, resultTree);
        return resultTree;
    }

    @Override
    public List<Map<String, Object>> getUnitListByType(String type) {

        if (type.equals("use")) {
            type = "使用单位";
        } else if (type.equals("maintenance")) {
            type = "维保单位";
        } else if (type.equals("inspection")) {
            type = "检验检测机构";
        }
        return commonMapper.getUnitListByType(type);
    }

    @Override
    public List<Map<String, Object>> getSecurityAdmin(String type) {
        ReginParams reginParams = JSON.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        CompanyBo company = reginParams.getCompany();
        String companyCode = company.getCompanyCode();
        String postName = null;
        if (type.equals("use")) {
            postName = "安全管理员";
        }
        if (type.equals("jyjc")) {
            postName = "检验检测人员";
        }
        if (type.equals("agw")) {
            postName = "安改维负责人";
        }
        return ObjectUtils.isEmpty(postName) ? new ArrayList<>() : commonMapper.getSecurityAdmin(companyCode, postName);
    }

    @Override
    public Map<String, Object> getUserInfo(String sequenceNbr) {
        return commonMapper.getUserInfo(sequenceNbr);
    }

    @Override
    public Map<String, Object> getEnterpriseInfo(String sequenceNbr) {
        return commonMapper.getEnterpriseInfo(sequenceNbr);
    }

    @Override
    public List<Map<String,Object>> getEnterpriseEmployee(String unitCode) {
        return commonMapper.getEnterpriseEmployee(unitCode);
    }

    /**
     * 将管辖机构树中children为[]的修改为null
     *
     * @param result
     * @return
     */
    private List<LinkedHashMap> updateNullChildren(List<LinkedHashMap> result) {
        Iterator it = result.iterator();
        while (it.hasNext()) {
            LinkedHashMap e = (LinkedHashMap) it.next();
            //将管辖机构树中children为[]的修改为null
            if (e.get("children") != null) {
                if (((List<LinkedHashMap>) e.get("children")).size() == 0) {
                    e.put("children", null);
                }
            }
            if (!ObjectUtils.isEmpty(e.get("children"))) {
                updateNullChildren((List<LinkedHashMap>) e.get("children"));
            }
        }
        return result;
    }

    /**
     * 删除管辖机构树中level为使用单位的数据
     *
     * @param result 管辖机构树
     * @return 筛选过滤后不包含使用单位的管辖机构树
     */
    private List<LinkedHashMap> deleteRegulatorTreeData(List<LinkedHashMap> result) {
        Iterator it = result.iterator();
        while (it.hasNext()) {
            LinkedHashMap e = (LinkedHashMap) it.next();
            //删除使用单位
            if ("company".equals(e.get("level"))) {
                it.remove();
            }
            if (e.get("companyName").toString().contains("行政审批局")) {
                it.remove();
            }
            // 删除检验检测机构
            if (!"company".equals(e.get("level")) && e.get("companyType").toString().contains("检验检测机构")) {
                it.remove();
            }
            if (!ObjectUtils.isEmpty(e.get("children"))) {
                deleteRegulatorTreeData((List<LinkedHashMap>) e.get("children"));
            }
        }
        return result;
    }
}