package com.yeejoin.amos.boot.module.jyjc.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.ArrayList;
import java.util.List;

@AllArgsConstructor
@Getter
public enum DocumentEnum {


    GZS("gzs", "告知书"),
    CPZL("cpzl", "产品质量证明书"),
    SGZX("sgzx", "施工自行检查报告"),
    SGHT("sght", "施工合同或证明"),
    SGFA("sgfa", "施工方案/施工设计文件"),
    SGDWXK("sgdwxk", "施工单位许可证书"),
    XSSY("xssy", "型式试验证书"),
    XSQTS("xsqts", "限速器和渐进式安全钳的调试证书"),
    TJSM("tjsm", "土建声明"),
    ZLBZ("zlbz", "质量保证手册和程序文件"),
    SGZY("sgzy", "施工作业文件"),
    SGRY("sgry", "施工人员、质量保证体系责任人、专业技术人员身份证、技术工人的身份证及资质证书"),
    SGSJ("sgsj", "施工设计文件"),
    SGFB("sgfb", "施工分包方目录"),
    FBSPJ("fbspj", "分包方评价资料"),
    QT("qt", "其他附件");

    private String code;
    private String name;

    public static List<String> getEnumNameList() {
        List<String> codeList = new ArrayList<String>();
        for (DocumentEnum c: DocumentEnum.values()) {
            codeList.add(c.getCode());
        }
        return codeList;
    }
    }
