package com.yeejoin.amos.boot.module.jyjc.api.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.typroject.tyboot.core.rdbms.model.BaseModel;

import java.util.Date;

/**
 * @author system_generator
 * @date 2023-12-14
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "JyjcInspectionApplicationEquipModel", description = "")
public class JyjcInspectionApplicationEquipModel extends BaseModel {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "报检申请表主键")
    private Long applicationSeq;

    @ApiModelProperty(value = "设备唯一标识")
    private String equipUnicode;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "业务类型（与菜单对应拆表使用）")
    private String bizType;

    @ApiModelProperty(value = "设备类别")
    private String equCategory;

    @ApiModelProperty(value = "设备类别名称")
    private String equCategoryName;

    @ApiModelProperty(value = "检验检测类型编码")
    private String inspectionType;

    @ApiModelProperty(value = "检验检测类型名称（冗余）")
    private String inspectionTypeName;

    @ApiModelProperty(value = "报检日期")
    private Date applicationDate;

    @ApiModelProperty("检验结果方式")
    private String resultType;

    @ApiModelProperty(value = "设备种类")
    private String equList;

    @ApiModelProperty(value = "设备种类名称")
    private String equListName;

    @ApiModelProperty(value = "设备品种")
    private String equDefine;

    @ApiModelProperty(value = "使用登记证编号")
    private String useOrgCode;

    @ApiModelProperty(value = "单位内部编号")
    private String useInnerCode;

    @ApiModelProperty(value = "注册代码")
    private String equCode;

    @ApiModelProperty(value = "设备使用地点省")
    private String provinceName;

    @ApiModelProperty(value = "设备使用地点市")
    private String cityName;

    @ApiModelProperty(value = "设备使用地点区")
    private String countyName;

    @ApiModelProperty(value = "设备使用地点街道")
    private String streetName;

    @ApiModelProperty(value = "设备使用地点详细")
    private String address;

    @ApiModelProperty(value = "使用单位")
    private String useUnitName;
    @ApiModelProperty(value = "施工单位")
    private String uscUnitName;

    @ApiModelProperty(value = "使用单位统一信用代码")
    private String useUnitCreditCode;

    @ApiModelProperty(value = "设备名称 ")
    private String productName;
    @ApiModelProperty(value = "品牌")
    private String brandName;
    @ApiModelProperty(value = "监管码")
    private String superVisonryCode;
    @ApiModelProperty(value = "型号")
    private String equType;
    @ApiModelProperty(value = "制造单位名称")
    private String productUnitName;
    @ApiModelProperty(value = "制造日期")
    private String productDate;
   // @ApiModelProperty(value = "使用年限")
   // private String use;
}
