package com.yeejoin.amos.boot.module.ugp.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 焊工工作履历表
 *
 * @author system_generator
 * @date 2022-09-22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="WorkHistoryDto", description="焊工工作履历表")
public class WorkHistoryDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "焊工id")
    private Long welderId;

    @ApiModelProperty(value = "工作单位名称")
    private String companyName;

    @ApiModelProperty(value = "工作单位id")
    private Long companyId;

    @ApiModelProperty(value = "项目名称")
    private String projectName;

    @ApiModelProperty(value = "项目id")
    private Long projectId;

    @ApiModelProperty(value = "所在职位")
    private String posts;

    @ApiModelProperty(value = "焊口数量")
    private Integer weldNumber;

    @ApiModelProperty(value = "开始时间")
    private String startDate;

    @ApiModelProperty(value = "结束时间")
    private Date endDate;

    @ApiModelProperty(value = "备注")
    private String remark;

    /**
     * 焊工姓名
     */
    private String name;
}
