package com.yeejoin.equipmanage.listener;

import com.yeejoin.equipmanage.common.utils.EnumsUtils;
import com.yeejoin.equipmanage.common.vo.AreaResquest;
import com.yeejoin.equipmanage.event.SynAreaRiskEvent;
import com.yeejoin.equipmanage.operation.AreaSynRiskOperator;
import com.yeejoin.equipmanage.operation.SyncRiskOperator;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

import java.util.Optional;

@Component
public class SynAreaRiskListener implements ApplicationListener<SynAreaRiskEvent> {


    @Override
    public void onApplicationEvent(SynAreaRiskEvent event) {
        // 根据operation(操作类型作相应业务)
        Optional<AreaSynRiskOperator> m = EnumsUtils.getEnumObject(AreaSynRiskOperator.class,
                e -> e.getType().equals(String.valueOf(event.operation())));
        calculate(event.areaResquest(), m.get());
    }

    public void calculate(AreaResquest areaResquest, AreaSynRiskOperator operator) {
        operator.apply(areaResquest);
    }
}
