package com.yeejoin.amos.boot.module.tzs.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@AllArgsConstructor
@Getter
public enum EquipmentClassifityEnum {

    /**
    **设备分类
     */
    锅炉("锅炉","1000"),
    压力容器("压力容器","2000"),
    电梯("电梯","3000"),
    起重机械("起重机械","4000"),
    厂内专用机动车辆("场（厂）内专用机动车辆","5000"),
    大型游乐设施("大型游乐设施","6000"),
    压力管道元件("压力管道元件","7000"),
    压力管道("压力管道","8000");
    private String name;
    private String code;
    public static Map<String,String> getName=new HashMap<>();
    public static Map<String,String> getCode=new HashMap<>();
    static {
        for (EquipmentClassifityEnum e : EquipmentClassifityEnum.values()){
            getName.put(e.code, e.name);
            getCode.put(e.name, e.code);
        }

    }
}
