package com.yeejoin.amos.boot.module.tzs.flc.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.tzs.flc.api.entity.CylinderUnit;
import org.apache.ibatis.annotations.Param;

/**
 * 气瓶企业信息 Mapper 接口
 *
 * @author system_generator
 * @date 2021-12-14
 */
public interface CylinderUnitMapper extends BaseMapper<CylinderUnit> {

    /**
     * 获取上个月企业总量
     * @return
     */
    Integer getLastMonthUnitTotal(@Param("regionCode") String regionCode);

    /**
     * 获取上上个月企业总量
     * @return
     */
    Integer getMonthBeforeLastUnitTotal(@Param("regionCode") String regionCode);

    /**
     * 根据regioncode 获取企业总量
     * @param regionCode
     * @return
     */
    Integer getUnitTotalByRegionCode(@Param("regionCode") String regionCode);

    Integer getWarnNum(String code);
    
    Integer getWarnNumByAppId(String appId);

    /**
     * 根据creditCode查询该企业是否存在许可超期
     * @param creditCode 统一社会信用代码
     * @return
     */
    Integer getLicenseOutOfDate(String creditCode);
}
