package com.yeejoin.amos.boot.module.ugp.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "PipeDto", description = "管段信息")
public class PipeDto extends BaseDto {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "管段名称")
    private String pipeName;

    @ApiModelProperty(value = "施工图号")
    private String constructionDrawingNum;

    @ApiModelProperty(value = "管段编号")
    private String pipeCode;

    @ApiModelProperty(value = "管段级别")
    private String pipeLevel;

    @ApiModelProperty(value = "管段起点（经纬度）")
    private String startPosition;

    @ApiModelProperty(value = "管段终点（经纬度）")
    private String endPosition;

    @ApiModelProperty(value = "管段长度")
    private Float length;

    @ApiModelProperty(value = "材质")
    private String material;

    @ApiModelProperty(value = "规格")
    private String specification;

    @ApiModelProperty(value = "设计压力")
    private Float designPressure;

    @ApiModelProperty(value = "设计温度")
    private Float designTemperature;

    @ApiModelProperty(value = "介质")
    private String medium;

    @ApiModelProperty(value = "关联项目id")
    private Long projectId;

    @ApiModelProperty(value = "起点名称")
    private String startName;

    @ApiModelProperty(value = "终点名称")
    private String endName;

}
