package com.yeejoin.amos.boot.module.jg.api.dto;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;

import java.util.HashMap;
import java.util.Map;

public class InspectTypeConverter implements Converter<String> {

    public static final Map<String, String> dictMap = new HashMap<>();

    static {
        // 填充映射关系
        dictMap.put("定期检验", "DQJY");
        dictMap.put("首次检验", "SCJY");
        dictMap.put("安装监督检验", "AZJDJY");
        dictMap.put("改造监督检验", "GZJDJY");
        dictMap.put("维修监督检验", "WXJDJY");
        dictMap.put("制造监督检验", "ZZJDJY");
        dictMap.put("电梯检测", "DTJC");
        dictMap.put("委托检验", "WTJY");
    }

    @Override
    public Class<?> supportJavaTypeKey() {
        // 实体类中对象属性类型
        return String.class;
    }

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    @Override
    public String convertToJavaData(CellData cellData, ExcelContentProperty excelContentProperty,
                                    GlobalConfiguration globalConfiguration) {
        // 从Cell中读取数据
        String cellValue = cellData.getStringValue();
        // 判断Excel中的值，将其转换为预期的数值
        return dictMap.getOrDefault(cellValue, null);
    }

    @Override
    public CellData convertToExcelData(String o, ExcelContentProperty excelContentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        return new CellData("");
    }
}