package com.yeejoin.equipmanage.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.equipmanage.common.dto.FileManageDto;
import com.yeejoin.equipmanage.common.entity.FileManage;
import com.yeejoin.equipmanage.mapper.FileManageMapper;
import com.yeejoin.equipmanage.service.FileManageService;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@Service
public class FileManageServiceImpl extends ServiceImpl<FileManageMapper, FileManage> implements FileManageService {

    @Override
    public void saveFileManage(FileManageDto dto) {
        FileManage fileManage = new FileManage();
        BeanUtils.copyProperties(dto, fileManage);
        fileManage.setCreateDate(new Date());
        this.save(fileManage);
    }

    @Override
    public Map<String, Object> getFileManageByPage(FileManageDto dto) {
        Page<Map<String, Object>> fileManageByPage = this.baseMapper.getFileManageByPage(new Page<>(dto.getPageNumber(), dto.getPageSize()), dto);
        Map<String, Object> countInfo = this.baseMapper.getCountInfo(dto);
        HashMap<String, Object> resultMap = new HashMap<>();
        resultMap.put("pageInfo", fileManageByPage);
        resultMap.put("topInfo", countInfo);
        return resultMap;
    }

    @Override
    public Page<Map<String, Object>> getFileManageByName(FileManageDto dto) {
        return this.baseMapper.getFileManageByName(new Page<>(dto.getPageNumber(), dto.getPageSize()), dto);
    }
}
