package com.yeejoin.equipmanage.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.equipmanage.common.entity.EquipmentSpecificIndex;
import com.yeejoin.equipmanage.common.vo.IotDataVO;
import com.yeejoin.equipmanage.common.vo.TopicEntityVo;
import com.yeejoin.equipmanage.service.IEquipmentSpecificIndexService;
import com.yeejoin.equipmanage.service.MqttWaringReceiveService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Slf4j
@Service
public class MqttWarningReceiveServiceImpl implements MqttWaringReceiveService {

    /**
     * 泡沫罐KEY
     */
    private final static String CAFS_FoamTank_FoamTankLevel = "CAFS_FoamTank_FoamTankLevel";
    /**
     * 泡沫罐KEY
     */
    private final static String FHS_PipePressureDetector_PipePressure = "FHS_PipePressureDetector_PipePressure";
    /**
     * 水池信息
     */
    private final static String FHS_FirePoolDevice_WaterLevel = "FHS_FirePoolDevice_WaterLevel";

    private final static String FHS_LevelDetector_WaterLevel = "FHS_LevelDetector_WaterLevel";
    /**
     * 水池信息
     */
    private final static String FHS_WirelessliquidDetector_WaterLevel = "FHS_WirelessliquidDetector_WaterLevel";
    /**
     * 水箱液位
     */
    private final static String CAFS_WaterTank_WaterTankLevel = "CAFS_WaterTank_WaterTankLevel";

    private final static String FHS_PressurePump_Start = "FHS_PressurePump_Start";

    private static final String REALTIME_IOT_INDEX_KEY = "realtime_iot_index_key";

    private static final String REALTIME_IOT_INDEX_VALUE = "realtime_iot_index_value";

    @Autowired
    MqttReceiveServiceImpl mqttReceiveService;

    @Autowired
    IEquipmentSpecificIndexService equipmentSpecificIndexService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void handlerMqttMessage(String topic, String message) {
        try {
            JSONObject messageObj = JSON.parseObject(message);
            IotDataVO iotDataVO = new IotDataVO();
            iotDataVO.setKey(messageObj.get(REALTIME_IOT_INDEX_KEY).toString());
            iotDataVO.setValue(messageObj.get(REALTIME_IOT_INDEX_VALUE).toString());
            EquipmentSpecificIndex equipmentSpeIndex = new EquipmentSpecificIndex();
            equipmentSpeIndex.setEquipmentSpecificId(Long.valueOf(messageObj.get("id").toString()));
            equipmentSpeIndex.setEquipmentSpecificName(messageObj.get("name").toString());
            equipmentSpeIndex.setEquipmentSpecificCode(messageObj.get("code").toString());
            equipmentSpeIndex.setLocation(messageObj.get("position").toString());
            equipmentSpeIndex.setBizOrgCode(messageObj.get("biz_org_code").toString());
            equipmentSpeIndex.setBizOrgName(messageObj.get("biz_org_name").toString());
            equipmentSpeIndex.setIotCode(messageObj.get("iot_code").toString());
            List<EquipmentSpecificIndex> indexList = equipmentSpecificIndexService
                    .getEquipmentSpeIndexBySpeIotCode(messageObj.get("iot_code").toString());
            List<EquipmentSpecificIndex> collect = indexList.stream().filter(item -> !ObjectUtils.isEmpty(item.getNameKey()) && item.getNameKey().equalsIgnoreCase(messageObj.get(REALTIME_IOT_INDEX_KEY).toString())).collect(Collectors.toList());
            equipmentSpeIndex.setUnit(CollUtil.isNotEmpty(collect) && ObjectUtil.isNotEmpty(collect.get(0)) && StrUtil.isNotEmpty(collect.get(0).getUnit()) ? collect.get(0).getUnit() : "m");
            isAlarmFlag(equipmentSpeIndex, iotDataVO);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void isAlarmFlag(EquipmentSpecificIndex equipmentSpeIndex, IotDataVO iotDataVO) {
        //管网压力、泡沫罐信息、水箱液位告警处理
        if (iotDataVO.getKey().equalsIgnoreCase(CAFS_FoamTank_FoamTankLevel) ||
                FHS_PipePressureDetector_PipePressure.equalsIgnoreCase(iotDataVO.getKey()) ||
                iotDataVO.getKey().equalsIgnoreCase(CAFS_WaterTank_WaterTankLevel)) {
            mqttReceiveService.doFoamTankLevel(iotDataVO, equipmentSpeIndex, null);
        }
        //消防水池液位处理
        if (iotDataVO.getKey().equalsIgnoreCase(FHS_FirePoolDevice_WaterLevel) ||
                iotDataVO.getKey().equalsIgnoreCase(FHS_WirelessliquidDetector_WaterLevel) ||
                iotDataVO.getKey().equalsIgnoreCase(FHS_LevelDetector_WaterLevel)) {
            mqttReceiveService.doWaterPoolLevel(iotDataVO, equipmentSpeIndex, null);
            // 处理每站消防储水量不少于4000m³ 预警问题
            mqttReceiveService.doWaterStationWarning(equipmentSpeIndex.getBizOrgCode(), equipmentSpeIndex.getBizOrgName());
        }
        //稳压泵启动次数大于15次触发预警
        if (iotDataVO.getKey().equalsIgnoreCase(FHS_PressurePump_Start) && "true".equals(iotDataVO.getValue().toString())) {
            TopicEntityVo topicEntity = new TopicEntityVo();
            topicEntity.setIotCode(equipmentSpeIndex.getIotCode());
            mqttReceiveService.doPressurePumInfo(topicEntity, equipmentSpeIndex);
        }

    }
}
