package com.yeejoin.amos.boot.module.jcs.biz.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.common.api.core.framework.PersonIdentify;
import com.yeejoin.amos.boot.module.common.api.service.IFirefightersService;
import com.yeejoin.amos.boot.module.common.biz.utils.CommonResponseUtil;
import com.yeejoin.amos.boot.module.jcs.api.mapper.SignMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;
import java.util.Objects;

@RestController
@Api(tags = "一张图大屏Api")
@RequestMapping(value = "/bigScreen")
public class BigScreenController extends BaseController {

    @Autowired
    private IFirefightersService iFirefightersService;

    @Autowired
    SignMapper signMapper;

    @Autowired
    private RedisUtils redisUtils;

    @GetMapping(value = "/getFireForceInfoByCode")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "消防车、消防力量信息（专职消防队、运维人员）、人员出勤", notes = "消防车、消防力量信息（专职消防队、运维人员、人员出勤）")
    public ResponseModel getFireForceInfoByCode(@RequestParam(required = false, value = "companyCode") String companyCode) {
        return CommonResponseUtil.success(iFirefightersService.getFireForceInfoByCode(companyCode));
    }

    @PersonIdentify
    @GetMapping(value = "/getUserInfo")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "应急预案页面消防力量人员信息", notes = "应急预案页面消防力量人员信息")
    public ResponseModel getUserInfoByYJYA(@ApiParam(value = "3小概览用--  0-运行人员  1-驻站消防队 【为空时为应急预案页面使用】") @RequestParam(required = false) Integer fireTeamType) {
        ReginParams reginParam = JSON.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        String bizOrgCode = null;
        if(null != reginParam) {
            bizOrgCode = reginParam.getPersonIdentity().getBizOrgCode();
            if (StringUtils.isEmpty(bizOrgCode)) {
                return CommonResponseUtil.success(null);
            }
        } else {
            return CommonResponseUtil.success(null);
        }
        List<Map<String, Object>> userInfoByYJYA = iFirefightersService.getUserInfoByYJYA(bizOrgCode);
        if (!Objects.isNull(fireTeamType)) {
            return CommonResponseUtil.success(userInfoByYJYA.get(fireTeamType));
        }
        return CommonResponseUtil.success(userInfoByYJYA);
    }

    /**
     * 今日打卡驻站消防队员列表清单--分页【运维概览 页面用】
     *
     * @return ResponseModel
     */
    @PersonIdentify
    @GetMapping(value = "/sign-person")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "今日打卡驻站消防队员列表清单", notes = "今今日打卡驻站消防队员列表清单")
    public ResponseModel signPersonPageList(
            @ApiParam(value = "当前页", required = true) @RequestParam(value = "current") int current,
            @ApiParam(value = "页面大小", required = true) @RequestParam(value = "size") int size) {
        ReginParams reginParam = JSON.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        String bizOrgCode = null;
        if(null != reginParam) {
            bizOrgCode = reginParam.getPersonIdentity().getBizOrgCode();
            if (StringUtils.isEmpty(bizOrgCode)) {
                return CommonResponseUtil.success(null);
            }
        }
        return CommonResponseUtil.success(iFirefightersService.signPersonPageList(current, size, bizOrgCode));
    }

    /**
     * 今日打卡驻站消防队员列表清单--分页【运维概览 页面用】
     *
     * @return ResponseModel
     */
    @PersonIdentify
    @GetMapping(value = "/getStationTypeList")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "获取换流站信息 - 特高压和常规", notes = "获取换流站信息 - 特高压和常规")
    public ResponseModel getStationTypeList() {
        return CommonResponseUtil.success(signMapper.getStationTypeList());
    }
}
