package com.yeejoin.precontrol.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.precontrol.common.entity.RiskWorkPersonRequirement;
import com.yeejoin.precontrol.common.service.IRiskWorkPersonRequirementService;
import com.yeejoin.precontrol.common.utils.NameUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;


/**
 * 风险作业人员要求表
 *
 * @author duanwei
 * @date 2021-01-28
 */
@RestController
@Api(tags = "风险作业人员要求表Api")
@RequestMapping(value = "/risk-work-person-requirement", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class RiskWorkPersonRequirementController {

    @Autowired
    IRiskWorkPersonRequirementService iRiskWorkPersonRequirementService;


    /**
     * 新增风险作业人员要求表
     *
     * @return
     */
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增风险作业人员要求表", notes = "新增风险作业人员要求表")
    public boolean saveRiskWorkPersonRequirement(HttpServletRequest request, @RequestBody RiskWorkPersonRequirement riskWorkPersonRequirement) {
        return iRiskWorkPersonRequirementService.save(riskWorkPersonRequirement);
    }

    /**
     * 根据id删除
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public boolean deleteById(HttpServletRequest request, @PathVariable Long id) {
        return iRiskWorkPersonRequirementService.removeById(id);
    }


    /**
     * 修改风险作业人员要求表
     *
     * @return
     */
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "修改风险作业人员要求表", notes = "修改风险作业人员要求表")
    public boolean updateByIdRiskWorkPersonRequirement(HttpServletRequest request, @RequestBody RiskWorkPersonRequirement riskWorkPersonRequirement) {
        return iRiskWorkPersonRequirementService.updateById(riskWorkPersonRequirement);
    }


    /**
     * 根据id查询
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/{id}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
    public RiskWorkPersonRequirement selectById(HttpServletRequest request, @PathVariable Long id) {
        return iRiskWorkPersonRequirementService.getById(id);
    }


    /**
     * 列表分页查询
     *
     * @return
     */
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
    public IPage<RiskWorkPersonRequirement> listPage(String pageNum, String pageSize,
                                                     RiskWorkPersonRequirement riskWorkPersonRequirement) {

        Page<RiskWorkPersonRequirement> pageBean;
        QueryWrapper<RiskWorkPersonRequirement> riskWorkPersonRequirementQueryWrapper = new QueryWrapper<>();
        Class<? extends RiskWorkPersonRequirement> aClass = riskWorkPersonRequirement.getClass();
        Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
            try {
                ReflectionUtils.makeAccessible(field);
                Object o = field.get(riskWorkPersonRequirement);
                if (o != null) {
                    Class<?> type = field.getType();
                    String name = NameUtils.camel2Underline(field.getName());
                    if (type.equals(Integer.class)) {
                        Integer fileValue = (Integer) field.get(riskWorkPersonRequirement);
                        riskWorkPersonRequirementQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(Long.class)) {
                        Long fileValue = (Long) field.get(riskWorkPersonRequirement);
                        riskWorkPersonRequirementQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(String.class)) {
                        String fileValue = (String) field.get(riskWorkPersonRequirement);
                        riskWorkPersonRequirementQueryWrapper.eq(name, fileValue);
                    } else {
                        String fileValue = (String) field.get(riskWorkPersonRequirement);
                        riskWorkPersonRequirementQueryWrapper.eq(name, fileValue);
                    }
                }
            } catch (Exception e) {
            }
        });
        IPage<RiskWorkPersonRequirement> page;
        if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
            pageBean = new Page<>(0, Long.MAX_VALUE);
        } else {
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        page = iRiskWorkPersonRequirementService.page(pageBean, riskWorkPersonRequirementQueryWrapper);
        return page;
    }
}


