package com.yeejoin.amos.supervision.business.dao.mapper;

import com.yeejoin.amos.supervision.business.param.TaskDetailParam;
import com.yeejoin.amos.supervision.business.param.TaskPageParam;
import com.yeejoin.amos.supervision.business.param.TaskStatisticsParam;
import com.yeejoin.amos.supervision.business.vo.CheckTaskDetailVo;
import com.yeejoin.amos.supervision.business.vo.TaskDetailVo;
import com.yeejoin.amos.supervision.business.vo.TaskStatisticsVo;
import com.yeejoin.amos.supervision.core.common.response.TaskInfoRespone;
import com.yeejoin.amos.supervision.dao.entity.Task;
import org.apache.ibatis.annotations.Param;

import java.util.HashMap;
import java.util.List;
import java.util.Map;


public interface TaskMapper extends BaseMapper{

	public void updateTask(Task taskInfo);

	public void updateTaskDetail(TaskDetailParam detail);

	public Map queryTaskCharts(HashMap<String, Object> request);

	public List<Map> queryTasks(HashMap<String, Object> request);

	public long countTaskInfoData(TaskPageParam param);

	public List<HashMap<String,Object>> getTaskPageInfo(TaskPageParam param);

	public List<HashMap<String, Object>> getHidDangerCtDtOfYear(HashMap<String, Object> params);

	public List<HashMap<String, Object>> getHidDangerCtDtOfMonth(HashMap<String, Object> params);

	public List<HashMap<String, Object>> getHidDangerCtDtOfCur(HashMap<String, Object> params);
	
	/**
	 * 根据任务id查询任务详情
	 * @param taskId
	 * @return
	 */
	public List<TaskInfoRespone> getTaskDetailInfoByTaskId(@Param(value="taskId") long taskId);

	/**
	 * 根据巡检路线IDs获取对应路线上的所有点ID
	 * @param routeID
	 * @return
	 */
	public List<HashMap<String, Object>> getPointIDsByRouteIDs(@Param(value="routeIDList") List<String> routeIDs);

	public HashMap<String, Object> getTaskForAppPie(HashMap<String, Object> params);

	/**
	 * 根据条件统计任务
	 * @param param
	 * @return
	 */
	public List<TaskStatisticsVo> getTaskStatistics(TaskStatisticsParam param);

	/**
	 * 	获取公司累计任务
	 * @param loginOrgCode
	 * @return
	 */
	public String getTaskFinishCountByOrgCode(@Param("orgCode") String loginOrgCode);

	/**
	 * 查询任务检查项列表
	 */
	public List<TaskDetailVo> findByTaskDetailId(@Param("taskID") Long taskID);

	/**
	 * 查询检查项任务 不合格项 巡检记录详情
	 * @param checkId
	 * @param taskId
	 * @return
	 */
	public List<CheckTaskDetailVo> queryCheckTaskInputItems(@Param("checkId") long checkId, @Param("taskId") long taskId);
	
	public List<String> queryCheckTaskInputItemImg(@Param("checkId") long checkId,@Param("itemId") long itemId);

	/**
	 * 同步任务数据
	 * @param request
	 * @return
	 */
	public List<Map<String, Object>> synchronizedOfflineTasks(Map<String, Object> request);
	
	/**
	 * 根据任务id查询详情
	 * @param taskId
	 * @return
	 */
	public HashMap<String, Object> queryTaskInfoById(@Param("taskId") long taskId);
}
