package com.yeejoin.amos.boot.biz.common.feign;

import com.yeejoin.amos.component.feign.utils.FeignUtil;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 平台Feign service
 *
 * @author tb
 */
@Service
public class AmosFeignService {

    private final Logger logger = LogManager.getLogger(AmosFeignService.class);

    /**
     * 根据dictCode从平台获取数据字典
     *
     * @param dictCode
     * @return
     */
    public List<DictionarieValueModel> listDictionaryByDictCode(String dictCode) throws Exception {
        logger.info("===========>listDictionaryByDictCode方法请求参数：{}", dictCode);
        List<DictionarieValueModel> dictionaryModel;

        dictionaryModel = FeignUtil.remoteCall(() -> Systemctl.dictionarieClient.dictValues(dictCode));
        return dictionaryModel;
    }
}
