package com.yeejoin.amos.boot.module.jcs.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
* 力量调派
*
* @author tb
* @date 2021-06-17
*/
@Data
@ApiModel(value="PowerTransferDto", description="力量调派")
public class PowerTransferDto extends BaseDto {
    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "警情id")
    private Long alertCalledId;

    @ApiModelProperty(value = "调派单号")
    private String dispatchNum;

    @ApiModelProperty(value = "调派类型")
    private String dispatchType;

    @ApiModelProperty(value = "发送者")
    private String taskSenderName;

    @ApiModelProperty(value = "发送者id")
    private Long taskSenderId;

    @ApiModelProperty(value = "发送者单位")
    private String companyName;

    @ApiModelProperty(value = "地址")
    private String address;

    @ApiModelProperty(value = "坐标x")
    private String coordinateX;

    @ApiModelProperty(value = "坐标y")
    private String coordinateY;

    @ApiModelProperty(value = "救援方格")
    private String rescueGrid;

    @ApiModelProperty(value = "车地址")
    private String carAddress;

    @ApiModelProperty(value = "车坐标x")
    private String carCoordinateX;

    @ApiModelProperty(value = "车坐标y")
    private String carCoordinateY;

    @ApiModelProperty(value = "操作人名称")
    private String recUserName;

    @ApiModelProperty(value = "调派单位列表")
    private List<PowerTransferCompanyDto> powerTransferCompanyDotList;

}
