package com.yeejoin.amos.boot.module.jcs.api.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

import java.util.Date;

/**
 * 
 * <pre>
 * 警情信息ES实体
 * </pre>
 *
 * @author gwb
 * @version $Id: ESAlertCalled.java, v 0.1 2021年6月19日 下午5:12:31 gwb Exp $
 */
@Data
@Accessors(chain = true)
@Document(indexName = "jcs", type = "alertCalled", shards = 1, replicas = 0)
public class ESAlertCalled {

    /** 主键 */
    @Id
    private Long sequenceNbr;
    /**
     * 警情状态
     */
    @ApiModelProperty(value = " 警情状态")
    @Field(type = FieldType.Text, searchAnalyzer = "ik_smart", analyzer = "ik_smart")
    private Boolean alertStatus;
//	/**
//	 * 系统/人工
//	 */
//    @Field(type = FieldType.Text, searchAnalyzer = "ik_max_word", analyzer = "ik_max_word")
//    private String type;
    
//    @Field(type = FieldType.Text, searchAnalyzer = "ik_max_word", analyzer = "ik_max_word")
//    private String alertStage;
//    /**
//     * 报警类型
//     */
//    @Field(type = FieldType.Text, searchAnalyzer = "ik_max_word", analyzer = "ik_max_word")
//    private String alarmType;
    /**
     * 响应级别字典code 为了过滤用（只有航空器故障有）
     */
    @ApiModelProperty(value = "响应级别")
    @Field(type = FieldType.Text)
    private String responseLevelCode;
    /**
     * 警情阶段
     */
    @ApiModelProperty(value = "警情阶段")
    @Field(type = FieldType.Text)
    private String alertStage;
//    /**
//     * 报警类型code
//     */
//    @Field(type = FieldType.Text, searchAnalyzer = "ik_max_word", analyzer = "ik_max_word")
//    private String alarmTypeCode;
//    /**
//     * 通话记录信息id
//     */
//    @Field(type = FieldType.Text, searchAnalyzer = "ik_max_word", analyzer = "ik_max_word")
//    private Integer callRecordId;
//    /**
//     * 父警情id
//     */
//    private Long fatherAlert;
    /**
     * 联系人姓名
     */
    @ApiModelProperty(value = "联系人姓名")
    @Field(type = FieldType.Text)
    private String contactUser;
    /**
     * 联系人电话
     */
    @ApiModelProperty(value = "联系人电话")
    @Field(type = FieldType.Text)
    private String contactPhone;
    /**
     * 接警时间
     */
    @ApiModelProperty(value = "接警时间")
    @Field(type = FieldType.Date, format = DateFormat.basic_date_time)
    private Date callTime;
//    /**
//     * 接警时长
//     */
//    private Double callTimeNum;
//    /**
//     * 警情来源
//     */
//    private String alertSource;
//    /**
//     * 警情来源code
//     */
//    private String alertSourceCode;
    /**
     * 警情类型
     */
    @ApiModelProperty(value = "警情类型")
    @Field(type = FieldType.Text, searchAnalyzer = "ik_smart", analyzer = "ik_smart")
    private String alertType;
//    /**
//     * 警情类型code
//     */
//    private String alertTypeCode;
    /**
     * 事发单位
     */
    @ApiModelProperty(value = "事发单位")
    @Field(type = FieldType.Text, searchAnalyzer = "ik_max_word", analyzer = "ik_max_word")
    private String unitInvolved;
//    /**
//     * 被困人数
//     */
//    private Integer trappedNum;
//    /**
//     * 伤亡人数
//     */
//    private Integer casualtiesNum;
    /**
     * 地址
     */
    @ApiModelProperty(value = "地址")
    @Field(type = FieldType.Text, searchAnalyzer = "ik_max_word", analyzer = "ik_max_word")
    private String address;
//    /**
//     * 救援方格
//     */
//    private String rescueGrid;
    /**
     * 坐标x
     */
    @ApiModelProperty(value = "坐标x")
    private String coordinateX;
    /**
     * 坐标y
     */
    @ApiModelProperty(value = "坐标y")
    private String coordinateY;
//    /**
//     * 更新时间
//     */
//    private Date updateTime;
//    /**
//     * 发送人名称
//     */
//    private String recUserName;
//    /**
//     * 接警时间开始---用于列表过滤
//     */
//    private Date callTimeStart ;
//    /**
//     * 接警时间结束---用于列表过滤
//     */
//    private Date callTimeEnd ;
//    /**
//     * 是否处警
//     */
//    private Boolean isFatherAlert;

}
