package com.yeejoin.amos.boot.module.jcs.api.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;
/**
* 人员学历
*
* @author tb
* @date 2021-06-07
*/
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("cb_firefighters_education")
@ApiModel(value="FirefightersEducation对象", description="人员学历")
public class FirefightersEducation extends BaseEntity {

  


    @ApiModelProperty(value = "人员id")
    private Long firefightersId;

    @ApiModelProperty(value = "第一学历")
    private String firstDegree;

    @ApiModelProperty(value = "最高学历")
    private String highestEducation;

    @ApiModelProperty(value = "学位")
    private String academicDegree;

    @ApiModelProperty(value = "毕业院校")
    private String school;

    @ApiModelProperty(value = "毕业专业名称")
    private String professionalName;

    @ApiModelProperty(value = "更新时间")
    @TableField(fill=FieldFill.UPDATE)
    private Date updateTime;

    @ApiModelProperty(value = "操作人名称")
    @TableField(fill=FieldFill.INSERT_UPDATE)
    private String recUserName;
    
    @ApiModelProperty(value = "学历资质文件")
    @TableField(fill=FieldFill.INSERT_UPDATE)
    private String qualifications;
    

}
