package com.yeejoin.amos.boot.module.jcs.api.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;
/**
* 岗位信息
*
* @author tb
* @date 2021-06-07
*/
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("cb_firefighters_post")
@ApiModel(value="FirefightersPost对象", description="岗位信息")
public class FirefightersPost extends BaseEntity {

  


    @ApiModelProperty(value = "人员id")
    private Long firefightersId;

    @ApiModelProperty(value = "员工层级")
    private String employeeHierarchy;

    @ApiModelProperty(value = "行政职务")
    private String administrativePosition;

    @ApiModelProperty(value = "岗位资质")
    private String postQualification;

    @ApiModelProperty(value = "消防救援人员类别")
    private String category;

//    @ApiModelProperty(value = "消防救援人员状态")
//    private String state;

    @ApiModelProperty(value = "消防救援衔级别代码")
    private String level;

    @ApiModelProperty(value = "资质证书")
    private String qualificationCertificate;

    @ApiModelProperty(value = "消防专家领域")
    private String areasExpertise;

    
    @ApiModelProperty(value = "员工层级字典code")
    private String employeeHierarchyCode;

    @ApiModelProperty(value = "行政职务字典code")
    private String administrativePositionCode;

    @ApiModelProperty(value = "岗位资质字典code")
    private String postQualificationCode;

    @ApiModelProperty(value = "消防救援人员类别字典code")
    private String categoryCode;

//    @ApiModelProperty(value = "消防救援人员状态")
//    private String stateCode;

    @ApiModelProperty(value = "消防救援衔级别代码字典code")
    private String levelCode;

//    @ApiModelProperty(value = "资质证书字典code")
//    private String qualificationCertificateCode;

    @ApiModelProperty(value = "消防专家领域字典code")
    private String areasExpertiseCode;
    
    @ApiModelProperty(value = "是否专家_判断标识")
    private String isnoExpert;

    @ApiModelProperty(value = "更新时间")
    @TableField(fill=FieldFill.UPDATE)
    private Date updateTime;

    @ApiModelProperty(value = "操作人名称")
    @TableField(fill=FieldFill.INSERT_UPDATE)
    private String recUserName;

}
