package com.yeejoin.amos.boot.module.jcs.api.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
* 调派单位
*
* @author tb
* @date 2021-06-17
*/
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("jc_power_transfer_company")
@ApiModel(value="PowerTransferCompany对象", description="调派单位")
public class PowerTransferCompany extends BaseEntity {

    


    @ApiModelProperty(value = "调派单据id")
    private Long powerTransferId;

    @ApiModelProperty(value = "是否只派发机构")
    private Boolean isDistributionAgencies;

    @ApiModelProperty(value = " 单位id")
    private Long companyId;

    @ApiModelProperty(value = " 单位名称")
    private String companyName;

    @ApiModelProperty(value = "任务信息")
    private String taskInformation;

    @TableField(value = "REC_USER_NAME", fill = FieldFill.INSERT_UPDATE)
    @ApiModelProperty(value = "操作人名称")
    private String recUserName;

}
