package com.yeejoin.amos.boot.module.jcs.api.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
* 调派单位资源
*
* @author tb
* @date 2021-06-17
*/
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("jc_power_transfer_company_resources")
@ApiModel(value="PowerTransferCompanyResources对象", description="调派单位资源")
public class PowerTransferCompanyResources extends BaseEntity {

   


    @ApiModelProperty(value = "资源类型")
    private String type;

    @ApiModelProperty(value = "资源id")
    private String resourcesId;
    @ApiModelProperty(value = "调派关联部门id")
    protected Long  powerTransferCompanyId;
     
    @ApiModelProperty(value = "资源名称")
    private String resourcesName;

    @ApiModelProperty(value = "资源编号（如车牌号）")
    private String resourcesNum;

    @TableField(value = "REC_USER_NAME", fill = FieldFill.INSERT_UPDATE)
    @ApiModelProperty(value = "操作人名称")
    private String recUserName;

}
