package com.yeejoin.amos.boot.module.jcs.api.vo;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertFormValue;
import com.yeejoin.amos.boot.module.jcs.api.entity.OrgUsr;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
* 机构/部门/人员表
*
* @author tb
* @date 2021-06-18
*/
@Data
@Accessors(chain = true)
@TableName("cb_org_usr")
@ApiModel(value="OrgUsrVo", description="人员")
public class OrgPersonVo {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "人员基本信息")
    private  OrgUsr OrgUsr;

    @ApiModelProperty(value = "动态表单值")
    private List<AlertFormValue> alertFormValue;

    public OrgPersonVo(OrgUsr orgUsr, List<AlertFormValue> alertFormValue) {
        OrgUsr = orgUsr;
        this.alertFormValue = alertFormValue;
    }
}
