package com.yeejoin.amos.boot.module.jcs.api.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelTarget;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.constants.CommonConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * @author fengwang
 * @date 2021-06-21.
 */
@Data
@Accessors(chain = true)
@TableName("cb_org_usr")
@ApiModel(value="OrgUsrDownloadTemplateVO", description="")
@ExcelTarget("OrgUsrDownloadTemplateVO")
public class OrgUsrDownloadTemplateVO {

    @Excel(name = "机构名称",width = 30)
    @ApiModelProperty(value = "机构/部门名称")
    private String bizOrgName;

    @Excel(name = "机构编码",width = 30)
    @ApiModelProperty(value = "机构编码")
    private String bizOrgCode;

    @Excel(name = "amos中公司/部门ID",width = 30)
    @ApiModelProperty(value = "amos中公司/部门ID")
    private String amosOrgId;

    @Excel(name = "amos中公司/部门ID",width = 30)
    @ApiModelProperty(value = "amos中公司/部门编码")
    private String amosOrgCode;

    @Excel(name = "amos中公司/部门ID",width = 30)
    @ApiModelProperty(value = "机构类型（单位：COMPANY）")
    private String bizOrgType = CommonConstant.BIZ_ORG_TYPE_COMPANY;

    @Excel(name = "amos中公司/部门ID",width = 30)
    @ApiModelProperty(value = "所属建筑名称")
    private String buildName;

    @Excel(name = "amos中公司/部门ID",width = 30)
    @ApiModelProperty(value = "所属建筑ID")
    private String buildId;

    @Excel(name = "amos中公司/部门ID",width = 30)
    @ApiModelProperty(value = "归属机构/部门/人员")
    private String parentId;

    @Excel(name = "amos中公司/部门ID",width = 30)
    @ApiModelProperty(value = "扩展属性1")
    private String orgExpandAttr1;

}
