package com.yeejoin.amos.boot.module.jcs.api.vo;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.module.jcs.api.entity.OrgUsr;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
* 机构/部门/人员表
*
* @author tb
* @date 2021-06-18
*/
@Data
@Accessors(chain = true)
@TableName("cb_org_usr")
@ApiModel(value="OrgUsrVo", description="机构/部门/人员表")
public class OrgUsrFormVo {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "机构/部门人员基本信息")
    private OrgUsr OrgUsr;

    @ApiModelProperty(value = "动态表单值")
    private List<FormValue> dynamicFormAlert;

    @ApiModelProperty(value = "单位人员信息值")
    private List<OrgPersonFormVo> children;

    public OrgUsrFormVo(OrgUsr orgUsr, List<FormValue> formValue) {
        OrgUsr = orgUsr;
        this.dynamicFormAlert = formValue;
    }

    public OrgUsrFormVo(OrgUsr orgUsr, List<FormValue> dynamicFormAlert, List<OrgPersonFormVo> children) {
        this.OrgUsr = orgUsr;
        this.dynamicFormAlert = dynamicFormAlert;
        this.children = children;
    }
}
