package com.yeejoin.amos.boot.module.jcs.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.NameUtils;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertFormType;
import com.yeejoin.amos.boot.module.jcs.api.service.IAlertFormTypeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;


/**
* 动态表单类型
*
* @author tb
* @date 2021-06-17
*/
@RestController
@Api(tags = "动态表单类型Api")
@RequestMapping(value = "/alert-Form-type")
public class AlertFormTypeController extends BaseController {

    @Autowired
    IAlertFormTypeService iAlertFormTypeService;

    /**
    * 新增动态表单类型
    * @return
    */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增动态表单类型", notes = "新增动态表单类型")
    public boolean saveAlertFormType(HttpServletRequest request, @RequestBody AlertFormType alertFormType){
        return iAlertFormTypeService.save(alertFormType);
    }

    /**
    * 根据id删除
    * @param id
    * @return
    */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public boolean deleteById(HttpServletRequest request, @PathVariable Long id){
        return iAlertFormTypeService.removeById(id);
    }




    /**
    * 修改动态表单类型
    * @return
    */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "修改动态表单类型", notes = "修改动态表单类型")
    public boolean updateByIdAlertFormType(HttpServletRequest request, @RequestBody AlertFormType alertFormType){
        return iAlertFormTypeService.updateById(alertFormType);
    }



    /**
    * 根据id查询
    * @param id
    * @return
    */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{id}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
    public AlertFormType selectById(HttpServletRequest request, @PathVariable Long id){
        return iAlertFormTypeService.getById(id);
    }



    /**
    * 列表分页查询
    * @return
    */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
    public IPage<AlertFormType> listPage(String pageNum,String pageSize, AlertFormType alertFormType){

        Page<AlertFormType> pageBean;
        QueryWrapper<AlertFormType> alertFormTypeQueryWrapper = new QueryWrapper<>();
        Class<? extends AlertFormType> aClass = alertFormType.getClass();
        Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
            try {
                field.setAccessible(true);
                Object o = field.get(alertFormType);
                if (o != null) {
                    Class<?> type = field.getType();
                    String name = NameUtils.camel2Underline(field.getName());
                    if (type.equals(Integer.class)) {
                        Integer fileValue = (Integer) field.get(alertFormType);
                        alertFormTypeQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(Long.class)) {
                        Long fileValue = (Long) field.get(alertFormType);
                        alertFormTypeQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(String.class)) {
                        String fileValue = (String) field.get(alertFormType);
                        alertFormTypeQueryWrapper.eq(name, fileValue);
                    } else {
                        String fileValue = (String) field.get(alertFormType);
                        alertFormTypeQueryWrapper.eq(name, fileValue);
                    }
                }
            } catch (Exception e) {
                throw  new RuntimeException("系统异常");
            }
        });
        IPage<AlertFormType> page;
        if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
            pageBean = new Page<>(0, Long.MAX_VALUE);
        } else {
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        page = iAlertFormTypeService.page(pageBean, alertFormTypeQueryWrapper);
            return page;
        }
    }

