package com.yeejoin.amos.boot.module.jcs.biz.controller;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.NameUtils;
import com.yeejoin.amos.boot.module.jcs.api.dto.AlertSubmittedDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertCalled;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertSubmitted;
import com.yeejoin.amos.boot.module.jcs.api.entity.Template;
import com.yeejoin.amos.boot.module.jcs.api.enums.SubmissionMethodEnum;
import com.yeejoin.amos.boot.module.jcs.api.service.IAlertCalledService;
import com.yeejoin.amos.boot.module.jcs.api.service.IAlertSubmittedService;
import com.yeejoin.amos.boot.module.jcs.api.service.ITemplateService;
import com.yeejoin.amos.boot.module.jcs.api.vo.FormValue;
import com.yeejoin.amos.boot.module.jcs.api.vo.SchedulingReportingVo;
import com.yeejoin.amos.boot.module.jcs.api.vo.TemplateVo;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;


/**
 * 警情报送记录
 *
 * @author tb
 * @date 2021-06-17
 */
@RestController
@Api(tags = "警情报送记录Api")
@RequestMapping(value = "/alert-submitted")
public class AlertSubmittedController extends BaseController {

    @Autowired
    IAlertSubmittedService iAlertSubmittedService;

    @Autowired
    ITemplateService iTemplateService;

    @Autowired
    IAlertCalledService iAlertCalledService;

    /**
     * 新增警情报送记录
     *
     * @return
     */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增警情报送记录", notes = "新增警情报送记录")

    public ResponseModel<Object> saveAlertSubmitted(HttpServletRequest request, @RequestBody AlertSubmittedDto alertSubmittedDto) {
        return ResponseHelper.buildResponse(iAlertSubmittedService.save(alertSubmittedDto));

    }

    /**
     * 根据id删除
     *
     * @param id
     * @return
     */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")

    public ResponseModel<Boolean> deleteById(HttpServletRequest request, @PathVariable Long id){
        return ResponseHelper.buildResponse(iAlertSubmittedService.removeById(id));

   
    }

    /**
     * 修改警情报送记录
     *
     * @return
     */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "修改警情报送记录", notes = "修改警情报送记录")

    public ResponseModel<Boolean> updateByIdAlertSubmitted(HttpServletRequest request, @RequestBody AlertSubmitted alertSubmitted){
        return ResponseHelper.buildResponse(iAlertSubmittedService.updateById(alertSubmitted));

   
    }

    /**
     * 根据id查询
     *
     * @param id
     * @return
     */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{id}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
    public ResponseModel<AlertSubmitted> selectById(HttpServletRequest request, @PathVariable Long id){
        return ResponseHelper.buildResponse(iAlertSubmittedService.getById(id));

    }

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/scheduling/list", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "根据警情id查询融合调度列表", notes = "根据警情id查询融合调度列表")
    public ResponseModel<SchedulingReportingVo> listSchedulingByParam(@RequestBody AlertSubmittedDto queryParam) {
        queryParam.setSubmissionMethodCode(SubmissionMethodEnum.SMS.getCode());
        return ResponseHelper.buildResponse(iAlertSubmittedService.listSchedulingByParam(queryParam));
    }

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/reporting/list", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "根据警情id查询警情报送列表", notes = "根据警情id查询警情报送列表")

    public ResponseModel<SchedulingReportingVo> listReportingByParam(@RequestBody AlertSubmittedDto queryParam) {
        queryParam.setSubmissionMethodCode(SubmissionMethodEnum.SMS.getCode());
        return ResponseHelper.buildResponse(iAlertSubmittedService.listReportingByParam(queryParam));

    }

    /**
     * 列表分页查询
     *
     * @return
     */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
    public IPage<AlertSubmitted> listPage(String pageNum, String pageSize, AlertSubmitted alertSubmitted) {

        Page<AlertSubmitted> pageBean;
        QueryWrapper<AlertSubmitted> alertSubmittedQueryWrapper = new QueryWrapper<>();
        Class<? extends AlertSubmitted> aClass = alertSubmitted.getClass();
        Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
            if (field.getName().equals("serialVersionUID")) {
                return;
            }
            try {
                field.setAccessible(true);
                Object o = field.get(alertSubmitted);
                if (o != null) {
                    Class<?> type = field.getType();
                    String name = NameUtils.camel2Underline(field.getName());
                    if (type.equals(Integer.class)) {
                        Integer fileValue = (Integer) field.get(alertSubmitted);
                        alertSubmittedQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(Long.class) || "long".equals(type.toString())) {
                        Long fileValue = (Long) field.get(alertSubmitted);
                        alertSubmittedQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(String.class)) {
                        String fileValue = (String) field.get(alertSubmitted);
                        alertSubmittedQueryWrapper.eq(name, fileValue);
                    } else {
                        String fileValue = (String) field.get(alertSubmitted);
                        alertSubmittedQueryWrapper.eq(name, fileValue);
                    }
                }
            } catch (Exception e) {
                throw new RuntimeException("系统异常");
            }
        });
        IPage<AlertSubmitted> page;
        if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
            pageBean = new Page<>(0, Long.MAX_VALUE);
        } else {
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        page = iAlertSubmittedService.page(pageBean, alertSubmittedQueryWrapper);
        return page;
    }

    /**
     * 获取警情续报内容
     *
     * @param alertCalledId
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{alertCalledId}/alert_submitted", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "获取警情续报内容", notes = "获取警情续报内容")
    public ResponseModel<Object> getAlertSubmittedContent(@PathVariable Long alertCalledId) {
        ArrayList<TemplateVo> templateVos = new ArrayList<>();
        try {
            // 获取警情详情
            String companyName = getSelectedOrgInfo().getCompany().getCompanyName();
            AlertCalled alertCalled = iAlertCalledService.getById(alertCalledId);
            Map<String, Object> map = objectToMap(alertCalled);
            map.put("companyName", companyName);

            // 获取模板内容
            // 警情续报
            Template template = iTemplateService.getOne(new QueryWrapper<Template>().eq("type_code", "alert_submitted"));
            TemplateVo templateVo = new TemplateVo();
            BeanUtils.copyProperties(template, templateVo);
            templateVo.setData(map);
            templateVos.add(templateVo);
            // 非警情确认
            template = iTemplateService.getOne(new QueryWrapper<Template>().eq("type_code", "not_alert"));
            templateVo = new TemplateVo();
            BeanUtils.copyProperties(template, templateVo);
            templateVo.setData(map);
            templateVos.add(templateVo);
            // 警情结案
            template = iTemplateService.getOne(new QueryWrapper<Template>().eq("type_code", "alert_close"));
            templateVo = new TemplateVo();
            BeanUtils.copyProperties(template, templateVo);
            templateVo.setData(map);
            templateVos.add(templateVo);
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return ResponseHelper.buildResponse(templateVos);
    }

    /**
     * 将Object对象里面的属性和值转化成Map对象
     *
     * @param obj
     * @return
     * @throws IllegalAccessException
     */
    @SuppressWarnings("unchecked")
	public static Map<String, Object> objectToMap(Object obj) throws IllegalAccessException {
        Map<String, Object> map = new HashMap<>();
        Class<?> clazz = obj.getClass();
        Field[] fields = clazz.getDeclaredFields();

        for (Field field : fields) {
            field.setAccessible(true);
            String fieldName = field.getName();
            if ("dynamicFormAlert".equalsIgnoreCase(fieldName)) {
                List<FormValue> dynamicFormAlert = (List<FormValue>) field.get(obj);
                for (FormValue formValue : dynamicFormAlert) {
                    map.put(formValue.getLabel(), formValue.getValue());
                }
            } else {
                Object value = field.get(obj);
                map.put(fieldName, value);
            }
        }
        return map;
    }
}

