package com.yeejoin.amos.boot.module.jcs.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.Menu;
import com.yeejoin.amos.boot.biz.common.utils.NameUtils;
import com.yeejoin.amos.boot.biz.common.utils.TreeParser;
import com.yeejoin.amos.boot.module.jcs.api.entity.FireTeam;
import com.yeejoin.amos.boot.module.jcs.api.service.IFireTeamService;
import com.yeejoin.amos.boot.module.jcs.api.vo.FireTeamListVo;
import com.yeejoin.amos.boot.module.jcs.api.vo.FireTeamVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.*;


/**
 * 消防队伍
 *
 * @author tb
 * @date 2021-06-07
 */
@RestController
@Api(tags = "消防队伍Api")
@RequestMapping(value = "/jcs/fire-team")
public class FireTeamController extends BaseController {

    @Autowired
    IFireTeamService iFireTeamService;

    /**
     * 新增消防队伍
     *
     * @return
     */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增消防队伍", notes = "新增消防队伍")
    public ResponseModel<Object>  saveFireTeam(HttpServletRequest request, @RequestBody FireTeam fireTeam) {
        iFireTeamService.save(fireTeam);
        return ResponseHelper.buildResponse(null);
    }

    /**
     * 根据id删除
     *
     * @param id
     * @return
     */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public ResponseModel<Object>  deleteById(HttpServletRequest request, @PathVariable Long id) {
        iFireTeamService.update(new UpdateWrapper<FireTeam>().eq("sequence_nbr", id).set("is_delete", 1));
        return ResponseHelper.buildResponse(null);
    }


    /**
     * 修改消防队伍
     *
     * @return
     */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "修改消防队伍", notes = "修改消防队伍")
    public ResponseModel<Object> updateByIdFireTeam(HttpServletRequest request, @RequestBody FireTeam fireTeam) {
        iFireTeamService.updateById(fireTeam);
        return ResponseHelper.buildResponse(null);

    }


    /**
     * 根据id查询
     *
     * @param id
     * @return
     */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{id}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
    public ResponseModel<FireTeam> selectById(HttpServletRequest request, @PathVariable Long id) {
        return ResponseHelper.buildResponse(iFireTeamService.getById(id));
    }


    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/getList", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "新列表分页查询", notes = "新表分页查询")
    public ResponseModel<Page<FireTeamVo>> getFirefighters(Integer pageNum, Integer pageSize, FireTeamListVo fireTeamList) {
        //条件分页
        List<FireTeamVo> list = iFireTeamService.getFireTeam(pageNum, pageSize, fireTeamList);
        Map<String, Long> num = iFireTeamService.getFireTeamCount(pageNum, pageSize, fireTeamList);
        Page<FireTeamVo> pageBean = new Page<>(pageNum, pageSize, num.get("num"));
        pageBean.setRecords(list);
        return ResponseHelper.buildResponse(pageBean);
    }


    /**
     * 列表分页查询
     *
     * @return
     * @throws Exception
     */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/listTree", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "队伍树", notes = "队伍树")
    public ResponseModel<List<Menu>> listTree() throws Exception {
        Map<String, Object> columnMap = new HashMap<>();
        columnMap.put("is_delete", 0);
        Collection<FireTeam> list = iFireTeamService.listByMap(columnMap);
        List<Menu> menus = TreeParser.getTree(null, list, FireTeam.class.getName(), "getSequenceNbr", 2, "getName",
                "getParent");
        return ResponseHelper.buildResponse(menus);
    }


    /**
     * 列表分页查询
     *
     * @return
     */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
    public IPage<FireTeam> listPage(String pageNum, String pageSize, FireTeam fireTeam) {

        Page<FireTeam> pageBean;
        QueryWrapper<FireTeam> fireTeamQueryWrapper = new QueryWrapper<>();
        Class<? extends FireTeam> aClass = fireTeam.getClass();
        Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
            try {
                field.setAccessible(true);
                Object o = field.get(fireTeam);
                if (o != null) {
                    Class<?> type = field.getType();
                    String name = NameUtils.camel2Underline(field.getName());
                    if (type.equals(Integer.class)) {
                        Integer fileValue = (Integer) field.get(fireTeam);
                        fireTeamQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(Long.class)) {
                        Long fileValue = (Long) field.get(fireTeam);
                        fireTeamQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(String.class)) {
                        String fileValue = (String) field.get(fireTeam);
                        fireTeamQueryWrapper.eq(name, fileValue);
                    } else {
                        String fileValue = (String) field.get(fireTeam);
                        fireTeamQueryWrapper.eq(name, fileValue);
                    }
                }
            } catch (Exception e) {
                throw new RuntimeException("系统异常");
            }
        });
        IPage<FireTeam> page;
        if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
            pageBean = new Page<>(0, Long.MAX_VALUE);
        } else {
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        page = iFireTeamService.page(pageBean, fireTeamQueryWrapper);
        return page;
    }

    /**
     * 查询消防力量信息
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/list_fire_team", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "查询消防力量信息", notes = "查询消防力量信息")
    public List<FireTeamVo> list() {
        List<FireTeam> list = iFireTeamService.list();
        return null;
    }


}

