package com.yeejoin.amos.boot.module.jcs.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.NameUtils;
import com.yeejoin.amos.boot.module.jcs.api.entity.FirefightersContacts;
import com.yeejoin.amos.boot.module.jcs.api.service.IFirefightersContactsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;


/**
* 联系人
*
* @author tb
* @date 2021-06-07
*/
@RestController
@Api(tags = "联系人Api")
@RequestMapping(value = "/firefighters-contacts")
public class FirefightersContactsController extends BaseController {

    @Autowired
    IFirefightersContactsService iFirefightersContactsService;

    /**
    * 新增l联系人
    * @return
    */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增l联系人", notes = "新增l联系人")
    public boolean saveFirefightersContacts(HttpServletRequest request, @RequestBody FirefightersContacts firefightersContacts){
        return iFirefightersContactsService.save(firefightersContacts);
    }

    /**
    * 根据id删除
    * @param id
    * @return
    */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public boolean deleteById(HttpServletRequest request, @PathVariable Long id){
        return iFirefightersContactsService.removeById(id);
    }




    /**
    * 修改l联系人
    * @return
    */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "修改l联系人", notes = "修改l联系人")
    public boolean updateByIdFirefightersContacts(HttpServletRequest request, @RequestBody FirefightersContacts firefightersContacts){
        return iFirefightersContactsService.updateById(firefightersContacts);
    }



    /**
    * 根据id查询
    * @param id
    * @return
    */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{id}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
    public FirefightersContacts selectById(HttpServletRequest request, @PathVariable Long id){
        return iFirefightersContactsService.getById(id);
    }



    /**
    * 列表分页查询
    * @return
    */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
    public IPage<FirefightersContacts> listPage(String pageNum,String pageSize, FirefightersContacts firefightersContacts){

        Page<FirefightersContacts> pageBean;
        QueryWrapper<FirefightersContacts> firefightersContactsQueryWrapper = new QueryWrapper<>();
        Class<? extends FirefightersContacts> aClass = firefightersContacts.getClass();
        Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
            try {
                field.setAccessible(true);
                Object o = field.get(firefightersContacts);
                if (o != null) {
                    Class<?> type = field.getType();
                    String name = NameUtils.camel2Underline(field.getName());
                    if (type.equals(Integer.class)) {
                        Integer fileValue = (Integer) field.get(firefightersContacts);
                        firefightersContactsQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(Long.class)) {
                        Long fileValue = (Long) field.get(firefightersContacts);
                        firefightersContactsQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(String.class)) {
                        String fileValue = (String) field.get(firefightersContacts);
                        firefightersContactsQueryWrapper.eq(name, fileValue);
                    } else {
                        String fileValue = (String) field.get(firefightersContacts);
                        firefightersContactsQueryWrapper.eq(name, fileValue);
                    }
                }
            } catch (Exception e) {
                throw  new RuntimeException("系统异常");
            }
        });
        IPage<FirefightersContacts> page;
        if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
            pageBean = new Page<>(0, Long.MAX_VALUE);
        } else {
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        page = iFirefightersContactsService.page(pageBean, firefightersContactsQueryWrapper);
            return page;
        }
    }

