package com.yeejoin.amos.boot.module.jcs.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.NameUtils;
import com.yeejoin.amos.boot.module.jcs.api.entity.FirefightersJacket;
import com.yeejoin.amos.boot.module.jcs.api.service.IFirefightersJacketService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * 消防人员配装记录
 *
 * @author tb
 * @date 2021-06-07
 */
@RestController
@Api(tags = "消防人员配装记录Api")
@RequestMapping(value = "/firefighters-jacket")
public class FirefightersJacketController extends BaseController {

	@Autowired
	IFirefightersJacketService iFirefightersJacketService;

	/**
	 * 新增消防人员配装记录
	 * 
	 * @return
	 */
	@TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/save", method = RequestMethod.POST)
	@ApiOperation(httpMethod = "POST", value = "新增消防人员配装记录", notes = "新增消防人员配装记录")
	@Transactional
	public ResponseModel<Object> saveFirefightersJacket(HttpServletRequest request,
			@RequestBody List<FirefightersJacket> firefightersJacket) {			
		iFirefightersJacketService.saveOrUpdateBatch(firefightersJacket);
		return ResponseHelper.buildResponse(null);
	}

	/**
	 * 根据id删除
	 * 
	 * @param id
	 * @return
	 */
	@TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
	@ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
	public ResponseModel<Object> deleteById(HttpServletRequest request, @PathVariable Long id) {
	iFirefightersJacketService.update(new UpdateWrapper<FirefightersJacket>().eq("sequence_nbr", id).set("is_delete", 1));     
	return ResponseHelper.buildResponse(null);
	}

	/**
	 * 修改消防人员配装记录
	 * 
	 * @return
	 */
	@TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/updateById", method = RequestMethod.PUT)
	@ApiOperation(httpMethod = "PUT", value = "修改消防人员配装记录", notes = "修改消防人员配装记录")
	public ResponseModel<FirefightersJacket> updateByIdFirefightersJacket(HttpServletRequest request,
			@RequestBody FirefightersJacket firefightersJacket) {
		iFirefightersJacketService.updateById(firefightersJacket);
		return ResponseHelper.buildResponse(firefightersJacket);
	}

	/**
	 * 根据id查询
	 * 
	 * @param id
	 * @return
	 */
	@TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/{id}", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
	public ResponseModel<FirefightersJacket> selectById(HttpServletRequest request, @PathVariable Long id) {
		QueryWrapper<FirefightersJacket> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("firefighters_id", id);
		FirefightersJacket firefightersJacket = iFirefightersJacketService.getOne(queryWrapper);
		return ResponseHelper.buildResponse(firefightersJacket);
	}

	/**
	 * 列表分页查询
	 * 
	 * @return
	 */
	@TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/list", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
	public ResponseModel<IPage<FirefightersJacket>> listPage(String pageNum, String pageSize, FirefightersJacket firefightersJacket) {

		Page<FirefightersJacket> pageBean;
		QueryWrapper<FirefightersJacket> firefightersJacketQueryWrapper = new QueryWrapper<>();
		Class<? extends FirefightersJacket> aClass = firefightersJacket.getClass();
		Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
			try {
				field.setAccessible(true);
				Object o = field.get(firefightersJacket);
				if (o != null) {
					Class<?> type = field.getType();
					String name = NameUtils.camel2Underline(field.getName());
					if (type.equals(Integer.class)) {
						Integer fileValue = (Integer) field.get(firefightersJacket);
						firefightersJacketQueryWrapper.eq(name, fileValue);
					} else if (type.equals(Long.class)) {
						Long fileValue = (Long) field.get(firefightersJacket);
						firefightersJacketQueryWrapper.eq(name, fileValue);
					} else if (type.equals(String.class)) {
						String fileValue = (String) field.get(firefightersJacket);
						firefightersJacketQueryWrapper.eq(name, fileValue);
					} else if (type.equals(Date.class)) {
                    	Date fileValue = (Date) field.get(firefightersJacket);
                    	firefightersJacketQueryWrapper.eq(name, fileValue);
                    }else {
						String fileValue = (String) field.get(firefightersJacket);
						firefightersJacketQueryWrapper.eq(name, fileValue);
					}
				}
			} catch (Exception e) {
				throw  new RuntimeException("系统异常");
			}
		});
		IPage<FirefightersJacket> page;
		if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
			pageBean = new Page<>(0, Long.MAX_VALUE);
		} else {
			pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
		}
		page = iFirefightersJacketService.page(pageBean, firefightersJacketQueryWrapper);

		return ResponseHelper.buildResponse(page);

	}
}
