package com.yeejoin.amos.boot.module.jcs.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.constants.CommonConstant;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.ExcelUtils;
import com.yeejoin.amos.boot.biz.common.utils.NameUtils;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertFormValue;
import com.yeejoin.amos.boot.module.jcs.api.entity.OrgMenu;
import com.yeejoin.amos.boot.module.jcs.api.entity.OrgUsr;
import com.yeejoin.amos.boot.module.jcs.api.service.IAlertFormValueService;
import com.yeejoin.amos.boot.module.jcs.api.service.IOrgUsrService;
import com.yeejoin.amos.boot.module.jcs.api.vo.FormValue;
import com.yeejoin.amos.boot.module.jcs.api.vo.OrgUsrDownloadTemplateVO;
import com.yeejoin.amos.boot.module.jcs.api.vo.OrgUsrFormVo;
import com.yeejoin.amos.boot.module.jcs.api.vo.OrgUsrVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.*;


/**
 * 部门信息修改
 *
 * @author tb
 * @date 2021-06-18
 */
@RestController
@Api(tags = "单位Api")
@RequestMapping(value = "/org-usr")
public class OrgUsrController extends BaseController {

    @Autowired
    IOrgUsrService iOrgUsrService;
    @Autowired
    IAlertFormValueService iAlertFromValueService;

    /**
     * 新增单位信息
     *
     * @return
     */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增单位信息", notes = "新增单位信息")
    public ResponseModel saveOrgUsr(HttpServletRequest request, @RequestBody OrgUsrVo OrgUsrVo) {
        OrgUsr orgUsr = new OrgUsr();
        BeanUtils.copyProperties(OrgUsrVo,orgUsr);
        // 单位新增情况
        iOrgUsrService.save(orgUsr);
        // 动态表单
        List<AlertFormValue> alertFromValuelist = OrgUsrVo.getAlertFormValue();
        // 填充主键
        alertFromValuelist.stream().forEach(alertFromValue -> {
            alertFromValue.setAlertCalledId(orgUsr.getSequenceNbr());
        });
        // 保存动态表单数据
        iAlertFromValueService.saveBatch(alertFromValuelist);
        return ResponseHelper.buildResponse(null);
    }

    /**
     * 根据id删除
     *
     * @param id
     * @return
     */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public ResponseModel deleteById(HttpServletRequest request, @PathVariable Long id) {
        // 删除时，只作逻辑删除
        iOrgUsrService.update(new UpdateWrapper<OrgUsr>().eq("sequence_nbr", id).set("is_delete", CommonConstant.IS_DELETE_01));
        return ResponseHelper.buildResponse(null);
    }


    /**
     * 更新单位数据
     *
     * @return
     */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{id}", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "更新单位数据", notes = "更新单位数据")
    public ResponseModel updateByIdOrgUsr(HttpServletRequest request, @RequestBody OrgUsr orgUsr, @PathVariable Long id) {
        // 修改单位信息
        orgUsr.setSequenceNbr(id);
        iOrgUsrService.updateById(orgUsr);
        return ResponseHelper.buildResponse(null);
    }


    /**
     * 根据id查询单位
     *
     * @param id
     * @return
     */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{id}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "获取单位详情", notes = "获取单位详情")
    public ResponseModel selectById(HttpServletRequest request, @PathVariable Long id) {
        OrgUsr orgUsr = iOrgUsrService.getById(id);
        QueryWrapper queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("alert_called_id", id);
        // 动态表单数据
        List<AlertFormValue> list = iAlertFromValueService.list(queryWrapper);
        List<FormValue> formValue = new ArrayList();
        for (AlertFormValue alertFormValue : list) {
            FormValue value = new FormValue(alertFormValue.getFieldCode(), alertFormValue.getFieldName(), "text", alertFormValue.getFieldValue(),alertFormValue.isBlock());
            formValue.add(value);
        }
        return ResponseHelper.buildResponse(new OrgUsrFormVo(orgUsr, formValue));
    }


    /**
     * 根据bizOrgType分页查询
     *
     * @param bizOrgType
     * @return
     */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/selectByBizOrgType/{bizOrgType}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据bizOrgType分页查询", notes = "根据bizOrgType分页查询")
    public ResponseModel bizOrgTypeListPage(String pageNum, String pageSize, @PathVariable String bizOrgType) {
        Page<OrgUsr> pageBean = new Page();
        if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
            pageBean = new Page<>(0, Long.MAX_VALUE);
        } else {
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        return ResponseHelper.buildResponse(iOrgUsrService.page(pageBean, new QueryWrapper<OrgUsr>().eq("biz_org_type", bizOrgType)));
    }


    /**
     * 获取单位树
     *
     * @param
     * @return
     */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/companyTree", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "获取单位树", notes = "获取单位树")
    public ResponseModel selectCompanyTree() throws Exception {
        Map<String, Object> columnMap = new HashMap<>();
        columnMap.put("is_delete", CommonConstant.IS_DELETE_00);
        columnMap.put("biz_org_type", CommonConstant.BIZ_ORG_TYPE_COMPANY);
        List<OrgMenu> menus = iOrgUsrService.getTree(null, iOrgUsrService.listByMap(columnMap), OrgUsr.class.getName(), "getSequenceNbr", 2, "getBizOrgName", "getParentId", "getBizOrgType");
        return ResponseHelper.buildResponse(menus);
    }


    /**
     * 列表分页查询
     *
     * @return
     */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
    public IPage<OrgUsr> listPage(String pageNum, String pageSize, OrgUsr orgUsr) {

        Page<OrgUsr> pageBean;
        QueryWrapper<OrgUsr> orgUsrQueryWrapper = new QueryWrapper<>();
        Class<? extends OrgUsr> aClass = orgUsr.getClass();
        Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
            try {
                field.setAccessible(true);
                Object o = field.get(orgUsr);
                if (o != null) {
                    Class<?> type = field.getType();
                    String name = NameUtils.camel2Underline(field.getName());
                    if (type.equals(Integer.class)) {
                        Integer fileValue = (Integer) field.get(orgUsr);
                        orgUsrQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(Long.class)) {
                        Long fileValue = (Long) field.get(orgUsr);
                        orgUsrQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(String.class)) {
                        String fileValue = (String) field.get(orgUsr);
                        orgUsrQueryWrapper.eq(name, fileValue);
                    } else {
                        String fileValue = (String) field.get(orgUsr);
                        orgUsrQueryWrapper.eq(name, fileValue);
                    }
                }
            } catch (Exception e) {
            }
        });
        IPage<OrgUsr> page;
        if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
            pageBean = new Page<>(0, Long.MAX_VALUE);
        } else {
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        page = iOrgUsrService.page(pageBean, orgUsrQueryWrapper);
        return page;
    }

    /**
     * 根据orgCode获取单位人员列表
     *
     * @param orgCode
     * @return
     */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{orgCode}/users", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据orgCode获取单位人员列表", notes = "根据orgCode获取单位人员列表")
    public ResponseModel selectUsersByOrgCode(HttpServletRequest request, @PathVariable Long orgCode) {
//        Map<String, Object> columnMap = new LinkedHashMap<>();
//        columnMap.put("is_delete", CommonConstant.IS_DELETE_00);
//        columnMap.put("biz_org_code", orgCode);
//        columnMap.put("biz_org_type", CommonConstant.BIZ_ORG_TYPE_COMPANY);
//        // 查询出单位基本信息
//        OrgUsr company = iOrgUsrService.getOne(new QueryWrapper<OrgUsr>().allEq(columnMap));
//        if (company != null) {
//            QueryWrapper queryWrapper = new QueryWrapper<>();
//            queryWrapper.eq("alert_called_id", company.getSequenceNbr());
//            // 获取单位动态表单数据
//            List<AlertFormValue> list = iAlertFromValueService.list(queryWrapper);
//            List<FormValue> formValue = new ArrayList();
//            for (AlertFormValue alertFormValue : list) {
//                FormValue value = new FormValue(alertFormValue.getFieldCode(), alertFormValue.getFieldName(), "text", alertFormValue.getFieldValue());
//                formValue.add(value);
//            }
//            // 获取单位人员列表信息
//            Map<String, Object> personColumnMap = new LinkedHashMap<>();
//            personColumnMap.put("is_delete", CommonConstant.IS_DELETE_00);
//            personColumnMap.put("biz_org_code", orgCode);
//            personColumnMap.put("biz_org_type", CommonConstant.BIZ_ORG_TYPE_PERSON);
//            List<OrgPersonFormVo> orgPersonFormVos = new ArrayList<>();
//            Collection<OrgUsr> orgUsrs = iOrgUsrService.listByMap(personColumnMap);
//            orgUsrs.forEach(orgUsr -> {
//                QueryWrapper personQueryWrapper = new QueryWrapper<>();
//                queryWrapper.eq("alert_called_id", orgUsr.getSequenceNbr());
//                // 获取人员动态表单数据
//                List<AlertFormValue> personList = iAlertFromValueService.list(queryWrapper);
//                List<FormValue> personFormValue = new ArrayList();
//                for (AlertFormValue alertFormValue : list) {
//                    FormValue value = new FormValue(alertFormValue.getFieldCode(), alertFormValue.getFieldName(), "text", alertFormValue.getFieldValue());
//                    personFormValue.add(value);
//                }
//                // 添加单位人员信息列表
//                orgPersonFormVos.add(new OrgPersonFormVo(orgUsr, formValue));
//            });
//            return ResponseHelper.buildResponse(new OrgUsrFormVo(company, formValue, orgPersonFormVos));
//        }
//        return CommonResponseUtil.failure("根据orgCode获取单位人员列表失败");
        return ResponseHelper.buildResponse(null);
    }

    /**
     * 导出单位模板
     *
     * @param response
     * @param OrgUsrDownloadTemplateVO
     * @return
     */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "download-template/{type}", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "根据类型导出模板", notes = "根据类型导出模板")
    public ResponseModel downloadTemplate(HttpServletResponse response, @RequestBody List<OrgUsrDownloadTemplateVO> OrgUsrDownloadTemplateVO) throws UnsupportedEncodingException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddhhmmss");
        ExcelUtils.exportExcel(OrgUsrDownloadTemplateVO, "单位信息", "单位信息", OrgUsrDownloadTemplateVO.class, simpleDateFormat.format(new Date()) + ".xls", response);
        return ResponseHelper.buildResponse(null);
    }
}