package com.yeejoin.amos.boot.module.jcs.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.NameUtils;
import com.yeejoin.amos.boot.module.jcs.api.entity.PowerTransferCompanyResources;
import com.yeejoin.amos.boot.module.jcs.api.service.IPowerTransferCompanyResourcesService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import java.util.Arrays;


/**
 * 调派单位资源
 *
 * @author tb
 * @date 2021-06-17
 */
@RestController
@Api(tags = "调派单位资源Api")
@RequestMapping(value = "/power-transfer-company-resources")
public class PowerTransferCompanyResourcesController extends BaseController {

    @Autowired
    IPowerTransferCompanyResourcesService iPowerTransferCompanyResourcesService;

    /**
     * 新增调派单位资源
     *
     * @return 返回结果
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增调派单位资源", notes = "新增调派单位资源")
    public boolean savePowerTransferCompanyResources(@RequestBody PowerTransferCompanyResources powerTransferCompanyResources) {
        return iPowerTransferCompanyResourcesService.save(powerTransferCompanyResources);
    }

    /**
     * 根据id删除
     *
     * @param id id
     * @return 返回结果
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public boolean deleteById(@PathVariable Long id) {
        return iPowerTransferCompanyResourcesService.removeById(id);
    }


    /**
     * 修改调派单位资源
     *
     * @return 返回结果
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "修改调派单位资源", notes = "修改调派单位资源")
    public boolean updateByIdPowerTransferCompanyResources(@RequestBody PowerTransferCompanyResources powerTransferCompanyResources) {
        return iPowerTransferCompanyResourcesService.updateById(powerTransferCompanyResources);
    }


    /**
     * 根据id查询
     *
     * @param id id
     * @return 返回结果
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{id}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
    public PowerTransferCompanyResources selectById(@PathVariable Long id) {
        return iPowerTransferCompanyResourcesService.getById(id);
    }


    /**
     * 列表分页查询
     *
     * @return 返回结果
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
    public IPage<PowerTransferCompanyResources> listPage(String pageNum, String pageSize,
                                                         PowerTransferCompanyResources powerTransferCompanyResources) {

        Page<PowerTransferCompanyResources> pageBean;
        QueryWrapper<PowerTransferCompanyResources> powerTransferCompanyResourcesQueryWrapper = new QueryWrapper<>();
        Class<? extends PowerTransferCompanyResources> aClass = powerTransferCompanyResources.getClass();
        Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
            try {
                field.setAccessible(true);
                Object o = field.get(powerTransferCompanyResources);
                if (o != null) {
                    Class<?> type = field.getType();
                    String name = NameUtils.camel2Underline(field.getName());
                    if (type.equals(Integer.class)) {
                        Integer fileValue = (Integer) field.get(powerTransferCompanyResources);
                        powerTransferCompanyResourcesQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(Long.class)) {
                        Long fileValue = (Long) field.get(powerTransferCompanyResources);
                        powerTransferCompanyResourcesQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(String.class)) {
                        String fileValue = (String) field.get(powerTransferCompanyResources);
                        powerTransferCompanyResourcesQueryWrapper.eq(name, fileValue);
                    } else {
                        String fileValue = (String) field.get(powerTransferCompanyResources);
                        powerTransferCompanyResourcesQueryWrapper.eq(name, fileValue);
                    }
                }
            } catch (Exception e) {
                throw new RuntimeException("系统异常");
            }
        });
        IPage<PowerTransferCompanyResources> page;
        if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
            pageBean = new Page<>(0, Long.MAX_VALUE);
        } else {
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        page = iPowerTransferCompanyResourcesService.page(pageBean, powerTransferCompanyResourcesQueryWrapper);
        return page;
    }
}

