package com.yeejoin.amos.boot.module.jcs.biz.service.impl;

import com.google.common.collect.Lists;
import com.yeejoin.amos.boot.biz.common.utils.EnumsUtils;
import com.yeejoin.amos.boot.module.jcs.api.dto.AlertSubmittedDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertSubmitted;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertSubmittedObject;
import com.yeejoin.amos.boot.module.jcs.api.enums.AlertBusinessTypeEnum;
import com.yeejoin.amos.boot.module.jcs.api.enums.AlertSchedulingTypeEnum;
import com.yeejoin.amos.boot.module.jcs.api.enums.AlertSubmitTypeEnum;
import com.yeejoin.amos.boot.module.jcs.api.enums.SubmissionMethodEnum;
import com.yeejoin.amos.boot.module.jcs.api.mapper.AlertSubmittedMapper;
import com.yeejoin.amos.boot.module.jcs.api.service.IAlertSubmittedObjectService;
import com.yeejoin.amos.boot.module.jcs.api.service.IAlertSubmittedService;
import com.yeejoin.amos.boot.module.jcs.api.vo.AlertSubmittedExtVo;
import com.yeejoin.amos.boot.module.jcs.api.vo.SchedulingReportingVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.List;
import java.util.Optional;

/**
* 警情报送记录 服务实现类
*
* @author tb
* @date 2021-06-17
*/
@Service
public class AlertSubmittedServiceImpl extends BaseService<AlertSubmittedDto,AlertSubmitted,AlertSubmittedMapper> implements IAlertSubmittedService {

    @Autowired
    IAlertSubmittedObjectService iAlertSubmittedObjectService;

    @Override
    public SchedulingReportingVo listSchedulingByParam(AlertSubmittedDto queryParam) {
        SchedulingReportingVo schedulingReportingVo = new SchedulingReportingVo();
        List<AlertSubmittedExtVo> alertSubmittedExtVoList = this.baseMapper.listSchedulingByParam(queryParam);
        schedulingReportingVo.setSchedulingReportingList(alertSubmittedExtVoList);
        String extraInfo = "已调度电话" + alertSubmittedExtVoList.size() + "起";
        schedulingReportingVo.setExtraInfo(extraInfo);
        return schedulingReportingVo;
    }

    @Override
    public SchedulingReportingVo listReportingByParam(AlertSubmittedDto queryParam) {
        SchedulingReportingVo schedulingReportingVo = new SchedulingReportingVo();
        List<AlertSubmittedExtVo> alertSubmittedExtVoList = this.baseMapper.listReportingByParam(queryParam);
        schedulingReportingVo.setSchedulingReportingList(alertSubmittedExtVoList);
        String extraInfo = "已报送" + alertSubmittedExtVoList.size() + "条";
        schedulingReportingVo.setExtraInfo(extraInfo);
        return schedulingReportingVo;
    }

    @Override
    public Boolean save(AlertSubmittedDto alertSubmittedDto) {
        // 1.保存警情记录主表
        AlertSubmitted alertSubmitted = new AlertSubmitted();
        alertSubmitted.setAlertCalledId(alertSubmittedDto.getAlertCalledId());
        alertSubmitted.setBusinessTypeCode(alertSubmittedDto.getBusinessTypeCode());
        Optional<AlertBusinessTypeEnum> businessTypeEnum = EnumsUtils.getEnumObject(AlertBusinessTypeEnum.class,
                e -> e.getCode().equals(alertSubmittedDto.getBusinessTypeCode()));
        alertSubmitted.setBusinessType(businessTypeEnum.orElse(AlertBusinessTypeEnum.警情续报).getName());
        alertSubmitted.setCallLogId(alertSubmittedDto.getCallLogId());
        alertSubmitted.setSubmissionMethodCode(alertSubmittedDto.getSubmissionMethodCode());
        Optional<SubmissionMethodEnum> submissionMethodEnum = EnumsUtils.getEnumObject(SubmissionMethodEnum.class,
                e -> e.getCode().equals(alertSubmittedDto.getBusinessTypeCode()));
        alertSubmitted.setSubmissionMethod(submissionMethodEnum.orElse(SubmissionMethodEnum.SMS).getName());
        Optional<AlertSchedulingTypeEnum> alertSchedulingTypeEnum = EnumsUtils.getEnumObject(AlertSchedulingTypeEnum.class,
                e -> e.getCode().equals(alertSubmittedDto.getBusinessTypeCode()));
        alertSubmitted.setSchedulingTypeCode(alertSubmittedDto.getSchedulingTypeCode());
        alertSubmitted.setSchedulingType(alertSchedulingTypeEnum.orElse(AlertSchedulingTypeEnum.融合调度).getName());
        alertSubmitted.setSubmissionContent(alertSubmittedDto.getSubmitContent().toJSONString());

        this.baseMapper.insert(alertSubmitted);

        // 2.保存任务表
        List<AlertSubmittedObject> alertSubmittedObjectList = Lists.newArrayList();
        // 报送给单位
        if (AlertSubmitTypeEnum.Org.getKey().equals(alertSubmittedDto.getType())) {
            alertSubmittedDto.getSubmitCompanyList().forEach(company -> {
                AlertSubmittedObject alertSubmittedObject = new AlertSubmittedObject();
                alertSubmittedObject.setAlertSubmittedId(alertSubmitted.getSequenceNbr());
                alertSubmittedObject.setType(true);
                alertSubmittedObject.setCompanyId(company.getCompanyId());
                alertSubmittedObject.setCompanyName(company.getCompanyName());

                alertSubmittedObjectList.add(alertSubmittedObject);
            });
        } else {
            // 报送给个人
            alertSubmittedDto.getSubmitCompanyList().forEach(company -> {
                company.getPersonList().forEach(person -> {
                    AlertSubmittedObject alertSubmittedObject = new AlertSubmittedObject();
                    alertSubmittedObject.setAlertSubmittedId(alertSubmitted.getSequenceNbr());
                    alertSubmittedObject.setType(false);
                    alertSubmittedObject.setCompanyId(company.getCompanyId());
                    alertSubmittedObject.setCompanyName(company.getCompanyName());
                    alertSubmittedObject.setUserId(person.getPersonId());
                    alertSubmittedObject.setUserName(person.getPersonName());
                    alertSubmittedObject.setUserPhone(person.getPersonPhone());

                    alertSubmittedObjectList.add(alertSubmittedObject);
                });
            });
        }

        iAlertSubmittedObjectService.saveBatch(alertSubmittedObjectList);

        // 3.发送任务消息
        // 调用平台短信发送接口发送消息
        return true;
    }
}
