package com.yeejoin.amos.boot.module.jcs.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertCalled;
import com.yeejoin.amos.boot.module.jcs.api.entity.ESAlertCalled;
import com.yeejoin.amos.boot.module.jcs.api.service.IAlertCalledService;
import com.yeejoin.amos.boot.module.jcs.biz.dao.ESAlertCalledRepository;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

import javax.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 
 * <pre>
 * 警情信息ES检索服务
 * </pre>
 *
 * @author gwb
 * @version $Id: ESAlertCalledService.java, v 0.1 2021年6月19日 下午5:12:01 gwb Exp $
 */
@Service
public class ESAlertCalledService {

    @Autowired
    private ElasticsearchRestTemplate elasticsearchTemplate;
    
    @Autowired
    private ESAlertCalledRepository esAlertCalledRepository;
    
	@Autowired
	private IAlertCalledService iAlertCalledService;

	
	@PostConstruct
	public void init() 
	{
		//初始化ES，重建索引
		initEs();
	}
	
    /**
     * 
     * <pre>
     * 批量保存
     * </pre>
     *
     * @param list 警情信息列表
     */
    public void saveAll(List<ESAlertCalled> list) {
        esAlertCalledRepository.saveAll(list);
    }

    /**
     * 查询所有，根据接警时间降序排列
     *
     * @param current 页码
     * @param size    页面大小
     * @return Page对象
     */
//    public Page<ESAlertCalled> findAll(int current, int size) {
//        // 分页+排序
//    	Sort.Order order=new Sort.Order(Sort.Direction.DESC, "callTime");
//        return esAlertCalledRepository.findAll(PageRequest.of(current, size, Sort.by(order)));
//    }

    /**
     * 根据id查询ES存储对象
     *
     * @param sequenceNbr id
     * @return ES实例
     */
    public ESAlertCalled queryById(Long sequenceNbr) {
        return esAlertCalledRepository.findById(sequenceNbr).orElse(null);
    }

    /**
     * 根据关键字查询文档，关键字不为空时按相关性从大到小排序
     *
     * @param queryStr 关键字
     * @param current  当前页码
     * @param size     页面大小
     * @return
     */
    @SuppressWarnings({ "rawtypes" })
	public Page<ESAlertCalled> queryByKeys(ESAlertCalled alertCalled, int current, int size) 
    {
        // 条件构造，多条件循环匹配
        BoolQueryBuilder boolMust = QueryBuilders.boolQuery();
        
        long currentTime = System.currentTimeMillis() ;
        currentTime = currentTime - 30*60*1000;
        Date date=new Date(currentTime);
        
        boolMust.must(
        		QueryBuilders.boolQuery().minimumShouldMatch(1)
        		.should(QueryBuilders.termQuery("contactUser", alertCalled.getContactUser()))//联系人姓名
        		.should(QueryBuilders.termQuery("contactPhone", alertCalled.getContactPhone()))//联系人电话
        		.should(QueryBuilders.rangeQuery("callTime").gte(date))//接警时间，距离当前时间不超过半小时的
        		.should(QueryBuilders.termQuery("alertType", alertCalled.getAlertType()))//警情类型
        		.should(QueryBuilders.matchQuery("address", alertCalled.getAddress()))//事发地址
        		.should(QueryBuilders.matchQuery("unitInvolved", alertCalled.getUnitInvolved())) //事发单位
        		);
        // 创建查询构造器
        NativeSearchQueryBuilder queryBuilder = new NativeSearchQueryBuilder()
                // 分页
                .withPageable(PageRequest.of(current, size))
                // 排序
//                .withSort(SortBuilders.fieldSort("callTime").order(SortOrder.DESC))
                //过滤条件
                .withQuery(boolMust);

//        List<ESAlertCalled> articleEntities = elasticsearchTemplate.queryForObject(queryBuilder, ESAlertCalled.class);
//         对高亮词条进行操作
        SearchHits<ESAlertCalled> searchHits =elasticsearchTemplate.search(queryBuilder.build(), ESAlertCalled.class);
        
        Page<ESAlertCalled> result = new Page<ESAlertCalled>(current, size);
        List<ESAlertCalled> list = new ArrayList<>();
        for (SearchHit searchHit : searchHits.getSearchHits())
		{
        	JSONObject jsonObject = (JSONObject) JSONObject.toJSON(searchHit.getContent());
        	ESAlertCalled eSAlertCalled =JSONObject.toJavaObject(jsonObject, ESAlertCalled.class);
        	list.add(eSAlertCalled);
		}
        result.setRecords(list);
        result.setTotal(searchHits.getTotalHits());
        
//        Page<ESAlertCalled> result = new PageImpl(searchHits.getSearchHits(), 
//        		PageRequest.of(current, size), searchHits.getTotalHits());
//        SearchHits<ESAlertCalled> result = elasticsearchTemplate.search(queryBuilder, ESAlertCalled.class, new SearchHitMapping() {
////            public <T> SearchHits<T> mapResults(SearchResponse response, Class<T> aClass, Pageable pageable) {
////                List<ESAlertCalled> list = new ArrayList<>();
//////                for (SearchHit searchHit : response.getHits()) {
//////                    ESAlertCalled docEntity = JSON.parseObject(searchHit.getSourceAsString(), ESAlertCalled.class);
//////                    // 文档标题
//////                    HighlightField docTitle = searchHit.getHighlightFields().get("docTitle");
//////                    if (docTitle != null) {
//////                        docEntity.setDocTitle(docTitle.fragments()[0].toString());
//////                    }
//////                    // 文档内容
//////                    HighlightField textContent = searchHit.getHighlightFields().get("textContent");
//////                    if (textContent != null) {
//////                        docEntity.setSummary(textContent.fragments()[0].toString());
//////                    }
//////                    Set<String> tagInfoSet = new HashSet<>();
//////                    // 文档标签
//////                    HighlightField docTagsInfo = searchHit.getHighlightFields().get("docTags.tagInfo");
//////                    if (docTagsInfo != null) {
//////                        for (Text name : docTagsInfo.getFragments()) {
//////                            tagInfoSet.add(name.toString());
//////                        }
//////                    }
//////                    HighlightField contentTagsInfo = searchHit.getHighlightFields().get("contentTags.tagInfo");
//////                    if (contentTagsInfo != null) {
//////                        for (Text name : contentTagsInfo.getFragments()) {
//////                            tagInfoSet.add(name.toString());
//////                        }
//////                    }
//////                    // 删除不匹配的和重复的标签
//////                    deleteRepeatedTags(docEntity.getDocTags(), tagInfoSet);
//////                    deleteRepeatedTags(docEntity.getContentTags(), tagInfoSet);
//////
//////                    list.add(docEntity);
//////                }
////                return new SearchHitsImpl<T>((List<T>) list, PageRequest.of(current, size), response.getHits().getTotalHits());
////            }
//        });
        return result;
    }

//    
//    /**
//     * 为搜索结果添加人名翻译/汇总信息
//     *
//     * @param key     查询关键字
//     * @param current 页码
//     * @param size    每页数量
//     * @return Page对象
//     */
//    public com.baomidou.mybatisplus.extension.plugins.pagination.Page queryAndDetail(String key, int current, int size) {
//        List<Map<String, Object>> resList = new ArrayList<>();
//        Page<ESAlertCalled> entityPage = queryByKeys(key, current, size);
//        List<ESAlertCalled> docEntityList = entityPage.getContent();
//        Set<String> userSet = new HashSet<>();
//        for (ESAlertCalled ESAlertCalled : docEntityList) {
//            KnowledgeDocContentModel contentModel = JSON.parseObject(ESAlertCalled.getDocJson(), KnowledgeDocContentModel.class);
//            List<KnowledgeDynamicsValueModel> listByInstance = dynamicsValueService.queryByInstanceId(contentModel.getSequenceNbr());
//            Map<String, Object> fieldMap = Bean.listToMap(listByInstance, "fieldName", "fieldValue", KnowledgeDynamicsValueModel.class);
//            Map<String, Object> map = Bean.BeantoMap(ESAlertCalled);
//            // 收藏数/引用数
//            map.put("referenceNum", docLibraryService.getReferenceCount(contentModel.getSequenceNbr()));
//            map.put("collectionNum", docLibraryService.getCollectionCount(contentModel.getSequenceNbr()));
//            map.put("userId", contentModel.getUserId());
//            userSet.add(contentModel.getUserId());
//            map.putAll(fieldMap);
//            resList.add(map);
//        }
//        Map<String, String> userMap = RemoteData.getUserMap(userSet);
//        for (Map<String, Object> map : resList) {
//            map.put("userName", userMap.get(map.get("userId")));
//            map.remove("htmlContent");
//            map.remove("docJson");
//        }
//        com.baomidou.mybatisplus.extension.plugins.pagination.Page page = new com.baomidou.mybatisplus.extension.plugins.pagination.Page();
//        page.setTotal(entityPage.getTotalElements());
//        page.setSize(size);
//        page.setRecords(resList);
//        return page;
//    }

    /**
     * 
     * <pre>
     * 根据警情记录批量保存
     * </pre>
     *
     * @param alertCalleds 警情信息列表
     */
    public Boolean saveAlertCalledToES(List<AlertCalled> alertCalleds) 
    {
    	if (!ValidationUtil.isEmpty(alertCalleds))
		{
    		List<ESAlertCalled> esAlertCalleds = new ArrayList<>();
    		for (AlertCalled alertCalled : alertCalleds) 
    		{
    			ESAlertCalled esAlertCalled = new ESAlertCalled();
    			esAlertCalled.setSequenceNbr(alertCalled.getSequenceNbr());
    			esAlertCalled.setAlertType(alertCalled.getAlarmType());
    			esAlertCalled.setCallTime(alertCalled.getCallTime());
    			esAlertCalled.setContactUser(alertCalled.getContactUser());
    			esAlertCalled.setContactPhone(alertCalled.getContactPhone());
    			esAlertCalled.setUnitInvolved(alertCalled.getUnitInvolved());
    			esAlertCalled.setCoordinateX(alertCalled.getCoordinateX());
    			esAlertCalled.setCoordinateY(alertCalled.getCoordinateY());
    			esAlertCalleds.add(esAlertCalled);
    		}
    		this.saveAll(esAlertCalleds);
		}
    	return true;
    }

//    /**
//     * 将文档基本信息转为关键字符串
//     *
//     * @param baseInfo    基本信息
//     * @param enumCnEnMap 枚举字典数据
//     * @return
//     */
//    private String baseInfo2Str(Map<String, Object> baseInfo, Map<String, Map<String, String>> enumCnEnMap) {
//        StringBuilder infoStr = new StringBuilder();
//        for (String field : baseInfo.keySet()) {
//            if (DocContentService.DOC_TITLE.equals(field)) {
//                continue;
//            }
//            if (enumCnEnMap.containsKey(field)) {
//                String enumCn = enumCnEnMap.get(field).get(baseInfo.get(field));
//                if (!ValidationUtil.isEmpty(enumCn)) {
//                    infoStr.append(enumCn).append(" ");
//                }
//            } else {
//                Object value = baseInfo.get(field);
//                if (!ValidationUtil.isEmpty(value)) {
//                    infoStr.append(value.toString()).append(" ");
//                }
//            }
//        }
//        return infoStr.toString().trim();
//    }

//    /**
//     * 根据标签实例列表创建ES标签列表
//     */
//    private List<ESTagEntity> buildESTagsByInstanceList(List<KnowledgeTagInstanceModel> instanceList) {
//        List<ESTagEntity> tags = new ArrayList<>();
//        if (!ValidationUtil.isEmpty(instanceList)) {
//            for (KnowledgeTagInstanceModel instanceModel : instanceList) {
//                ESTagEntity tag = new ESTagEntity()
//                        .setSequenceNbr(instanceModel.getSequenceNbr())
//                        .setTagSeq(instanceModel.getTagSeq())
//                        .setTagName(instanceModel.getTagName())
//                        .setTagInfo(getTagInfoStr(instanceModel))
//                        .setTagJson(JSON.toJSONString(instanceModel));
//                tags.add(tag);
//            }
//        }
//        return tags;
//    }
//
//    /**
//     * 获取标签信息：标签名&值
//     *
//     * @param instanceModel 标签实例
//     * @return 信息文本
//     */
//    private String getTagInfoStr(KnowledgeTagInstanceModel instanceModel) {
//        StringBuilder infoStr = new StringBuilder();
//        infoStr.append(instanceModel.getTagName()).append(" ");
//        if (TagService.TAG_TYPE_TEXT.equals(instanceModel.getTagType())
//                || ValidationUtil.isEmpty(instanceModel.getTagValues())) {
//            return infoStr.toString().trim();
//        }
//        for (KnowledgeTagValueModel valueModel : instanceModel.getTagValues()) {
//            String fieldName = valueModel.getFieldName();
//            String tagValue = valueModel.getTagValue();
//            switch (fieldName) {
//                case TagValueService.VALUE_TAG_FIELD_DATE_H:
//                    infoStr.append(tagValue).append(" ");
//                    try {
//                        Date date = DateUtil.formatStringToDate(tagValue, null);
//                        infoStr.append(DateUtil.formatDate(date, DateUtil.YMD)).append(" ");
//                        infoStr.append(DateUtil.formatDate(date, DateUtil.YMDHM)).append(" ");
//                        infoStr.append(DateUtil.formatDate(date, DateUtil.ymd)).append(" ");
//                        infoStr.append(DateUtil.formatDate(date, DateUtil.Y_M_D)).append(" ");
//                        infoStr.append(DateUtil.formatDate(date, COMMON_FORMAT)).append(" ");
//                    } catch (Exception e) {
//                        e.printStackTrace();
//                    }
//                    break;
//                default:
//                    infoStr.append(tagValue).append(" ");
//            }
//        }
//        return infoStr.toString().trim();
//    }

    /**
     * 
     * <pre>
     *  从ES库批量删除
     * </pre>
     *
     * @param ids
     * @return
     * @throws Exception
     */
    public Boolean deleteById(List<Long> ids) throws Exception{
        if (!ValidationUtil.isEmpty(ids)) {
        	for (Long sequenceNbr : ids) {
        		if (esAlertCalledRepository.existsById(sequenceNbr)) {
        			esAlertCalledRepository.deleteById(sequenceNbr);
        		}
        	}
        }

        return true;
    }

    /**
     * 重建索引
     */
    public Boolean initEs() {
        esAlertCalledRepository.deleteAll();
        /**
         * 同步历史48小时以内的警情处置记录
         */
        QueryWrapper<AlertCalled> wrapper = new QueryWrapper<>();
        
        long currentTime = System.currentTimeMillis() ;
        currentTime = currentTime - 480*60*60*1000;
        Date date=new Date(currentTime);
        
        wrapper.ge("call_time", date);
        
        List<AlertCalled> alertCalleds = iAlertCalledService.list(wrapper);
        if (!ValidationUtil.isEmpty(alertCalleds))
		{
        	saveAlertCalledToES(alertCalleds);
		}
        return true;
    }
}
