package com.yeejoin.amos.boot.module.jcs.biz.service.impl;

import com.yeejoin.amos.boot.module.jcs.api.dto.OrgUsrDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.OrgMenu;
import com.yeejoin.amos.boot.module.jcs.api.entity.OrgUsr;
import com.yeejoin.amos.boot.module.jcs.api.mapper.OrgUsrMapper;
import com.yeejoin.amos.boot.module.jcs.api.service.IOrgUsrService;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
* 机构/部门/人员表 服务实现类
*
* @author tb
* @date 2021-06-18
*/
@Service
public class OrgUsrServiceImpl extends  BaseService<OrgUsrDto,OrgUsr,OrgUsrMapper>  implements IOrgUsrService {

    @Override
    @SuppressWarnings("unchecked")
    public List<OrgMenu> getTree(Long topId, Collection entityList, String packageURL, String IDMethodName, int IDHierarchy, String NAMEMethodName, String PARENTIDMethodName, String OrgTypeMethodName) throws Exception{
        List<OrgMenu> resultList=new ArrayList<>();
        Class clazz=  Class.forName(packageURL);
        Method IDMethodNameme = null;
        switch (IDHierarchy) { case 1:
            IDMethodNameme = clazz.getDeclaredMethod(IDMethodName);
            break;
            case 2:
                IDMethodNameme = clazz.getSuperclass().getDeclaredMethod(IDMethodName);
                break;
            case 3:
                IDMethodNameme = clazz.getSuperclass().getSuperclass().getDeclaredMethod(IDMethodName);
                break;
            default:
                IDMethodNameme = clazz.getDeclaredMethod(IDMethodName);
                break;
        }

        Method NAMEMethodNameme =  clazz.getDeclaredMethod(NAMEMethodName);
        Method PARENTIDMethodNameme = clazz.getDeclaredMethod(PARENTIDMethodName);
        Method OrgTypeMethodNameme = clazz.getDeclaredMethod(OrgTypeMethodName);
        //获取顶层元素集合
        Long parentId;
        for (Object ob : entityList) {

            Object entity = clazz.cast(ob);

            parentId=PARENTIDMethodNameme.invoke(entity)!=null? Long.valueOf(String.valueOf(PARENTIDMethodNameme.invoke(entity))):null;

            if(parentId==null||topId==parentId){
                OrgMenu menu=new OrgMenu(Long.valueOf(String.valueOf(IDMethodNameme.invoke(entity))), String.valueOf(NAMEMethodNameme.invoke(entity)), parentId,String.valueOf(OrgTypeMethodNameme.invoke(entity)),false);
                resultList.add(menu);
            }
        }
        //获取每个顶层元素的子数据集合
        for (OrgMenu entity : resultList) {
            entity.setChildren(getSub(entity.getKey(), entityList, packageURL, IDMethodName,IDHierarchy, NAMEMethodName, PARENTIDMethodName, OrgTypeMethodName));
        }

        return resultList;
    }

    @SuppressWarnings("unchecked")
	@Override
    public List<OrgMenu> getSub(Long topId, @SuppressWarnings("rawtypes") Collection entityList, String packageURL, String IDMethodName, int IDHierarchy, String NAMEMethodName, String PARENTIDMethodName, String OrgTypeMethodName) throws Exception{
        List<OrgMenu> childList=new ArrayList<>();
        @SuppressWarnings("rawtypes")
		Class clazz=  Class.forName(packageURL);
        Method IDMethodNameme = null;
        switch (IDHierarchy) {
            case 1:
                IDMethodNameme = clazz.getDeclaredMethod(IDMethodName);
                break;
            case 2:
                IDMethodNameme = clazz.getSuperclass().getDeclaredMethod(IDMethodName);
                break;
            case 3:
                IDMethodNameme = clazz.getSuperclass().getSuperclass().getDeclaredMethod(IDMethodName);
                break;
            default:
                IDMethodNameme = clazz.getDeclaredMethod(IDMethodName);
                break;
        }
        Method OrgTypeMethodNameme = clazz.getDeclaredMethod(OrgTypeMethodName);
        Method NAMEMethodNameme =  clazz.getDeclaredMethod(NAMEMethodName);
        Method PARENTIDMethodNameme = clazz.getDeclaredMethod(PARENTIDMethodName);

        Long parentId;
        //子集的直接子对象
        for (Object ob : entityList) {
            Object entity = clazz.cast(ob);

            parentId=PARENTIDMethodNameme.invoke(entity)!=null? Long.valueOf(String.valueOf(PARENTIDMethodNameme.invoke(entity))):null;

            if(parentId==null) {
                if(topId==parentId){
                    OrgMenu menu=new OrgMenu(Long.valueOf(String.valueOf(IDMethodNameme.invoke(entity))), String.valueOf(NAMEMethodNameme.invoke(entity)), parentId,String.valueOf(OrgTypeMethodNameme.invoke(entity)),false);
                    childList.add(menu);
                }
            }else {
                if(topId.longValue()==parentId.longValue()){
                    OrgMenu menu=new OrgMenu(Long.valueOf(String.valueOf(IDMethodNameme.invoke(entity))), String.valueOf(NAMEMethodNameme.invoke(entity)), parentId,String.valueOf(OrgTypeMethodNameme.invoke(entity)),true);
                    childList.add(menu);
                }
            }

        }

        //子集的间接子对象
        for (OrgMenu entity  : childList) {
            entity.setChildren(getSub(entity.getKey(), entityList, packageURL, IDMethodName,IDHierarchy, NAMEMethodName, PARENTIDMethodName,OrgTypeMethodName));
        }

        //递归退出条件
        if(childList.size()==0){
            return null;
        }

        return childList;
    }
}
