package com.yeejoin.amos.boot.module.jcs.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.module.jcs.api.dto.PowerTransferCompanyDto;
import com.yeejoin.amos.boot.module.jcs.api.dto.PowerTransferCompanyResourcesDto;
import com.yeejoin.amos.boot.module.jcs.api.dto.PowerTransferDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.*;
import com.yeejoin.amos.boot.module.jcs.api.mapper.PowerTransferMapper;
import com.yeejoin.amos.boot.module.jcs.api.service.*;
import com.yeejoin.amos.boot.module.jcs.api.vo.PowerTransferCompanyResourcesVo;
import com.yeejoin.amos.boot.module.jcs.api.vo.PowerTransferVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 力量调派 服务实现类
 *
 * @author tb
 * @date 2021-06-17
 */
@Service
public class PowerTransferServiceImpl extends BaseService<PowerTransferDto,PowerTransfer,PowerTransferMapper> implements IPowerTransferService {

    @Resource
    PowerTransferMapper powerTransferMapper;

    @Autowired
    IAlertCalledService iAlertCalledService;

    @Autowired
    IPowerTransferCompanyService iPowerTransferCompanyService;

    @Autowired
    IPowerTransferCompanyResourcesService iPowerTransferCompanyResourcesService;

    @Autowired
    ITemplateService iTemplateService;

    @Autowired
    IAlertFormValueService iAlertFormValueService;

    public PowerTransferVo getPowerTransferList(Long alertCalledId) {
        List<PowerTransferCompanyResourcesVo> powerTransferList =
                powerTransferMapper.getPowerTransferList(alertCalledId);
        PowerTransferVo powerTransferVo = new PowerTransferVo();
        int resourcesCount = powerTransferList.size();
        powerTransferVo.setResourcesCount(resourcesCount);
        powerTransferVo.setResourcesList(powerTransferList);
        return powerTransferVo;
    }

    @Override
    @Transactional
    public boolean createPowerTransfer(PowerTransferDto powerTransferDto) {
        // 获取调派ID
        Long alertCalledId = powerTransferDto.getAlertCalledId();
        int count = count(new QueryWrapper<PowerTransfer>().eq("alert_called_id", alertCalledId));
        String dispatch_num = alertCalledId.toString() + (count + 1);

        // 获取警情详情
        AlertCalled alertCalled = iAlertCalledService.getById(alertCalledId);

        // 创建力量调派
        PowerTransfer powerTransfer = new PowerTransfer();
        BeanUtils.copyProperties(powerTransferDto, powerTransfer);
        BeanUtils.copyProperties(alertCalled, powerTransfer);
        powerTransfer.setDispatchNum(dispatch_num);
        powerTransfer.setSequenceNbr(null);

        save(powerTransfer);
        Long powerTransferSequenceNbr = powerTransfer.getSequenceNbr();

        // 获取任务派发模板
        Template template = iTemplateService.getOne(new QueryWrapper<Template>().eq("type",
                alertCalled.getAlertType()));
        String content = template.getContent();
        Map<String, String> definitions = new HashMap<>();
        initDefinitions(definitions, alertCalled, powerTransferDto);

        // 创建力量调派单位
        createPowerTransferCompany(powerTransferDto, powerTransferSequenceNbr, definitions, content);
        return true;
    }

    private List<PowerTransferCompanyResources> DtoEntityBatchConvert(List<PowerTransferCompanyResourcesDto> powerTransferCompanyResourcesDtoList, Long powerTransferCompanySequenceNbr) {
        ArrayList<PowerTransferCompanyResources> powerTransferCompanyResourcesList = new ArrayList<>();
        PowerTransferCompanyResources powerTransferCompanyResources;
        for (PowerTransferCompanyResourcesDto powerTransferCompanyResourcesDto : powerTransferCompanyResourcesDtoList) {
            powerTransferCompanyResources = new PowerTransferCompanyResources();
            BeanUtils.copyProperties(powerTransferCompanyResourcesDto, powerTransferCompanyResources);
            powerTransferCompanyResources.setPowerTransferCompanyId(powerTransferCompanySequenceNbr);
            powerTransferCompanyResourcesList.add(powerTransferCompanyResources);
        }
        return powerTransferCompanyResourcesList;
    }

    private void initDefinitions(Map<String, String> definitions,
                                 AlertCalled alertCalled, PowerTransferDto powerTransferDto) {
        List<AlertFormValue> alertFormValue = iAlertFormValueService.list(new QueryWrapper<AlertFormValue>().eq(
                "alert_called_id", alertCalled.getSequenceNbr()));
        definitions.put("rescueGrid", alertCalled.getRescueGrid());
        definitions.put("alertType", alertCalled.getAlertType());
        definitions.put("address", alertCalled.getAddress());
        definitions.put("trappedNum", alertCalled.getTrappedNum().toString());
        definitions.put("casualtiesNum", alertCalled.getCasualtiesNum().toString());
        definitions.put("companyName", powerTransferDto.getCompanyName());

        for (AlertFormValue formValue : alertFormValue) {
            definitions.put(formValue.getFieldCode(), formValue.getFieldValue());
        }
    }

    private String getTaskInformation(String content, Map<String, String> definitions) {
        int size = definitions.size();
        String[] keys = definitions.keySet().toArray(new String[size]);
        String[] values = definitions.values().toArray(new String[size]);
        return StringUtils.replaceEach(content, keys, values);
    }

    private void createPowerTransferCompany(PowerTransferDto powerTransferDto, Long powerTransferSequenceNbr,
                                            Map<String, String> definitions, String content) {
        List<PowerTransferCompanyDto> powerTransferCompanyDotList = powerTransferDto.getPowerTransferCompanyDotList();
        PowerTransferCompany powerTransferCompany;

        for (PowerTransferCompanyDto powerTransferCompanyDto : powerTransferCompanyDotList) {
            powerTransferCompany = new PowerTransferCompany();
            BeanUtils.copyProperties(powerTransferCompanyDto, powerTransferCompany);
            powerTransferCompany.setPowerTransferId(powerTransferSequenceNbr);
            List<PowerTransferCompanyResourcesDto> powerTransferCompanyResourcesDtoList =
                    powerTransferCompanyDto.getPowerTransferCompanyResourcesDtoList();
            if (powerTransferCompanyResourcesDtoList.size() == 0) {
                powerTransferCompany.setIsDistributionAgencies(true);
                definitions.put("type", "");
                definitions.put("resourcesNum", "");
                powerTransferCompany.setTaskInformation(getTaskInformation(content, definitions));
                iPowerTransferCompanyService.save(powerTransferCompany);
            } else {
                powerTransferCompany.setIsDistributionAgencies(false);
                StringBuilder taskInformation = new StringBuilder();
                for (PowerTransferCompanyResourcesDto powerTransferCompanyResourcesDto :
                        powerTransferCompanyResourcesDtoList) {
                    definitions.put("type", powerTransferCompanyResourcesDto.getType());
                    definitions.put("resourcesNum", powerTransferCompanyResourcesDto.getResourcesNum());
                    String information = getTaskInformation(content, definitions);
                    taskInformation.append(information).append(";");
                }
                powerTransferCompany.setTaskInformation(taskInformation.toString());
                iPowerTransferCompanyService.save(powerTransferCompany);
                Long powerTransferCompanySequenceNbr = powerTransferCompany.getSequenceNbr();
                List<PowerTransferCompanyResources> powerTransferCompanyResourcesList =
                        DtoEntityBatchConvert(powerTransferCompanyResourcesDtoList, powerTransferCompanySequenceNbr);
                iPowerTransferCompanyResourcesService.saveBatch(powerTransferCompanyResourcesList);
            }
        }
    }
}
