package com.yeejoin.amos.boot.module.jcs.biz.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.yeejoin.amos.component.feign.config.InnerInvokException;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.component.feign.utils.FeignUtil;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.client.AgencyUserClient;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import com.yeejoin.amos.feign.privilege.model.DepartmentModel;
import com.yeejoin.amos.feign.privilege.model.PermissionModel;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;

/***
 *
 * 平台安全接口实现类
 *
 * ***/
@Service("remoteSecurityService")
public class RemoteSecurityService {

   
    @Autowired
    private HttpServletRequest request;

    // * 根据公司id查询机构用户

    public List<AgencyUserModel> listUserByCompanyId(String companyId) {
        if (StringUtils.isEmpty(companyId)) {
            return null;
        }
        List<AgencyUserModel> AgencyUserModel = null;
        FeignClientResult feignClientResult;
        try {
            feignClientResult = Privilege.agencyUserClient.queryByCompanyId(Long.valueOf(companyId), null);
            AgencyUserModel = (List<AgencyUserModel>) feignClientResult.getResult();

        } catch (InnerInvokException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
        return AgencyUserModel;
    }

    /**
     * 用户id批量获取用户信息
     *
     * @param userIds 用户ids
     * @return List<AgencyUserModel>
     */
    public List<AgencyUserModel> listUserByUserIds(String userIds) {
        List<AgencyUserModel> agencyUserModel = null;
        FeignClientResult feignClientResult;
        try {
            feignClientResult = Privilege.agencyUserClient.queryByIds(userIds);
            agencyUserModel = (List<AgencyUserModel>) feignClientResult.getResult();

        } catch (InnerInvokException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
        return agencyUserModel;
    }

    /**
     * 用户id获取用户信息
     *
     * @param userId 用户编号
     * @return AgencyUserModel
     */
    public AgencyUserModel getUserById(String userId) {
        if (StringUtils.isEmpty(userId)) {
            return null;
        }
        AgencyUserModel agencyUserModel;
        try {
            agencyUserModel = FeignUtil.remoteCall(() -> Privilege.agencyUserClient.queryByUserId(userId));
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
        return agencyUserModel;
    }

    // 根据orgCode查询机构用户
    public List<AgencyUserModel> listUserByOrgCode(String orgCode) {
        if (StringUtils.isEmpty(orgCode)) {
            return null;
        }
        Set<AgencyUserModel> agencyUserModel;
        try {
            agencyUserModel = FeignUtil.remoteCall(() -> Privilege.agencyUserClient.queryByOrgCode(orgCode));
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
        return new ArrayList<>(agencyUserModel);
    }

    // 根据部门id查询机构用户
    public List<AgencyUserModel> listUserByDepartmentId(Long departmentId) {
        if (departmentId == null) {
            return null;
        }
        List<AgencyUserModel> agencyUserModel;
        try {
            agencyUserModel = FeignUtil.remoteCall(() -> Privilege.agencyUserClient.queryByDepartmentId(departmentId, null));
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
        return agencyUserModel;
    }

    // 根据orgCode查询机构
    public Map<String, Object> listByOrgCode(String orgCode) {
        if (StringUtils.isEmpty(orgCode)) {
            return null;
        }
        Map<String, Object> agencyUserModel = null;
        FeignClientResult feignClientResult;
        try {
            feignClientResult = Privilege.companyClient.queryByOrgcode(orgCode);
            agencyUserModel = (Map<String, Object>) feignClientResult.getResult();
        } catch (InnerInvokException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
        return agencyUserModel;
    }

    // 查询指定公司的部门树
    public List<DepartmentModel> getDepartmentTreeByCompanyId(Long companyId) {
        if (companyId == null) {
            return null;
        }
        List<DepartmentModel> departmentModel = null;
        FeignClientResult feignClientResult;
        try {
            feignClientResult = Privilege.departmentClient.queryDeptTree(null, companyId);
            departmentModel = (List<DepartmentModel>) feignClientResult.getResult();

        } catch (InnerInvokException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
        return departmentModel;

    }


    /**
     * 基础平台全部菜单权限树,用于平台登录前端初始化路由
     */
    public ResponseModel<Object> searchPermissionTree(long id, String appType) {
        List<PermissionModel> dictionarieModel = null;
        FeignClientResult<Collection<PermissionModel>> feignClientResult;
        try {
            feignClientResult = Privilege.permissionClient.treeByRole(id, appType, null, null);
            dictionarieModel = (List<PermissionModel>) feignClientResult.getResult();

        } catch (InnerInvokException e) {
            throw new RuntimeException();
        }
        ResponseModel<Object> commonResponse = ResponseHelper.buildResponse( dictionarieModel);
        return commonResponse;
    }

    /**
     * 根据Code查询指定的字典信息
     *
     * @param dictCode 字典编号
     * @return List<DictionarieValueModel>
     */
    public List<DictionarieValueModel> listDictionaryByDictCode(String dictCode) {
        List<DictionarieValueModel> dictionarieModel = null;
        FeignClientResult<List<DictionarieValueModel>> feignClientResult;
        try {
            feignClientResult = Systemctl.dictionarieClient.dictValues(dictCode);
            dictionarieModel = (List<DictionarieValueModel>) feignClientResult.getResult();

        } catch (InnerInvokException e) {
            throw new RuntimeException();
        }

        return dictionarieModel;
    }

    /**
     * 查询指定公司信息与其部门用户树
     */
    public CompanyModel listUserByCompanyId1(Long companyId) {
        if (companyId == null) {
            return null;
        }
        CompanyModel companyModel = null;
        FeignClientResult feignClientResult;
        try {
            feignClientResult = Privilege.companyClient.withDeptAndUsers(companyId);
            companyModel = (CompanyModel) feignClientResult.getResult();

        } catch (InnerInvokException e) {
            throw new RuntimeException();
        }
        return companyModel;

    }

   

   

    public JSONArray listDepartmentUserTree(Long companyId) {

        CompanyModel companyModel = null;
        FeignClientResult feignClientResult;
        try {
            feignClientResult = Privilege.companyClient.withDeptAndUsers(companyId);
            companyModel = (CompanyModel) feignClientResult.getResult();

        } catch (InnerInvokException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }

        if (companyModel != null) {
            String jsonStr = null;

            jsonStr = JSON.toJSONString(companyModel.getChildren());

            return JSONArray.parseArray(jsonStr);
        }
        return null;

    }

    public boolean editPassword(String userId, String oldPassword, String newPassword) throws InnerInvokException {
        boolean flag = false;
        AgencyUserModel agencyUserModel = new AgencyUserModel();
        agencyUserModel.setPassword(newPassword);
        agencyUserModel.setRePassword(newPassword);
        agencyUserModel.setOriginalPassword(oldPassword);
        AgencyUserModel agencyUserModel2 = null;
        FeignClientResult feignClientResult;
        feignClientResult = Privilege.agencyUserClient.modifyPassword(userId, agencyUserModel);
        agencyUserModel = (AgencyUserModel) feignClientResult.getResult();
        if (agencyUserModel2 != null) {
            flag = true;
        }
        return false;
    }

    public FeignClientResult<Map<String, String>> fileImage(MultipartFile file) {
        String product = request.getHeader("product");
        String appKey = request.getHeader("appKey");
        try {
            RequestContext.setProduct(product);
            RequestContext.setAppKey(appKey);
            FeignClientResult<Map<String, String>> date = Systemctl.fileStorageClient.updateCommonFile(file);

            return date;
        } catch (InnerInvokException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }

    }

    public FeignClientResult<Map<String, String>> fileImage(MultipartFile[] files) {

        try {
            FeignClientResult<java.util.Map<String, String>> date = Systemctl.fileStorageClient
                    .updateCommonFiles(files);

            return date;
        } catch (InnerInvokException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }

    }

    public AgencyUserModel getAgencyUser() {
        FeignClientResult<AgencyUserModel> agencyUser = null;
        AgencyUserModel userModel = null;
        try {
            AgencyUserClient agencyUserClient = Privilege.agencyUserClient;
            agencyUser = agencyUserClient.getme();
            userModel = agencyUser.getResult();
        } catch (InnerInvokException e) {
            throw new RuntimeException(e.getMessage());
        }
        return userModel;
    }
}
