package com.yeejoin.precontrol.common.fileparser.factory;


import com.yeejoin.precontrol.common.fileparser.product.pdf.AbstractPdf;
import com.yeejoin.precontrol.common.fileparser.product.pdf.ExcelPdf;
import com.yeejoin.precontrol.common.fileparser.product.txt.AbstractText;
import com.yeejoin.precontrol.common.fileparser.product.txt.ExcelText;
import lombok.extern.slf4j.Slf4j;


/**
 * 类描述: excel文件转换工厂
 *
 * @author <a href="mailto:Ydm@nationsky.com">Ydm</a>
 * @version 1.0
 * @date 2016年3月7日
 * @see AbstractFactory
 * @since JDK 1.7
 */
@Slf4j
public class ExcelFactory implements AbstractFactory {




    @Override
    public void convert2Text(String fileName, String outPutFile) throws Exception {
        log.info("将Excel转换为txt文件开始,输出文件 [" + outPutFile + ".txt]......");
        long startTime = System.currentTimeMillis();
        AbstractText text = new ExcelText();
        text.createTxt(fileName, outPutFile);
        log.info("将Excel转换为txt文件......ok");
        log.info("Generate " + outPutFile + ".txt with " + (System.currentTimeMillis() - startTime)
                + " ms.");
    }

    @Override
    public boolean convert2Pdf(String fileName, String outPutFile) throws Exception {
        log.info("将Excel转换为pdf文件开始,输出文件 [" + outPutFile + ".pdf]......");
        long startTime = System.currentTimeMillis();
        AbstractPdf html = new ExcelPdf();
        html.createPdf(fileName, outPutFile);
        log.info("将Excel转换为pdf文件......ok");
        log.info("Generate " + outPutFile + ".pdf with " + (System.currentTimeMillis() - startTime)
                + " ms.");
        return false;
    }

    @Override
    public void convert2Html(String fileName, String outPutFile) throws Exception {

    }

    @Override
    public void convert2Png(String fileName, String outPutFile) throws Exception {

    }

}

