package com.yeejoin.equipmanage.common.datasync.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * @ProjectName: YeeFireDataProcessRoot
 * @Package: com.yeejoin.equipmanage.common.datasync.entity
 * @ClassName: GeographicalRegion
 * @Author: Jianqiang Gao
 * @Description: 设备
 * @Date: 2021/3/24 11:10
 * @Version: 1.0
 */
@Data
@Accessors(chain = true)
@TableName("ast_fireequipment")
@ApiModel(value = "FireEquipment对象", description = "设备数据")
public class FireEquipment implements Serializable {

    private static final long serialVersionUID = 6211934226192730747L;

    @ApiModelProperty(value = "ID")
    @TableId("id")
    private String id;

    @ApiModelProperty(value = "CIM的ID")
    @TableField("mrid")
    private String mRid;

    @ApiModelProperty(value = "实物ID")
    @TableField("materialobjectid")
    private String materialObjectId;

    @ApiModelProperty(value = "名称")
    @TableField("name")
    private String name;

    @ApiModelProperty(value = "编码")
    @TableField("code")
    private String code;

    @ApiModelProperty(value = "设备类别名称")
    @TableField("categoryname")
    private String categoryName;

    @ApiModelProperty(value = "设备类别编码")
    @TableField("categorycode")
    private String categoryCode;

    @ApiModelProperty(value = "设备图片")
    @TableField("img")
    private String img;

    @ApiModelProperty(value = "设备物联编码")
    @TableField("iotcode")
    private String iotCode;

    @ApiModelProperty(value = "站点名称")
    @TableField("stationname")
    private String stationName;

    @ApiModelProperty(value = "站点编码")
    @TableField("stationcode")
    private String stationCode;

    @ApiModelProperty(value = "所属区域")
    @TableField("workarea")
    private String workArea;

    @ApiModelProperty(value = "所在建筑ID")
    @TableField("buildid")
    private String buildId;

    @ApiModelProperty(value = "所在建筑名称")
    @TableField("buildname")
    private String buildName;

    @ApiModelProperty(value = "所属消防系统Ids")
    @TableField("fightingsystemids")
    private String fightingSystemIds;

    @ApiModelProperty(value = "位置")
    @TableField("position")
    private String position;

    @ApiModelProperty(value = "使用日期")
    @TableField("inusedate")
    private LocalDateTime inUseDate;

    @ApiModelProperty(value = "状态")
    @TableField("status")
    private String status;

    @ApiModelProperty(value = "使用状态")
    @TableField("inusestate")
    private String inUseState;

    @ApiModelProperty(value = "创建时间")
    @TableField("createdate")
    private Date createDate;

    @ApiModelProperty(value = "修改时间")
    @TableField("updatedate")
    private Date updateDate;

    @ApiModelProperty(value = "别名")
    @TableField("aliasname")
    private String aliasname;

    @ApiModelProperty(value = "描述")
    @TableField("description")
    private String description;

    @ApiModelProperty(value = "辅助监控设备类型")
    @TableField("kind")
    private String kind;

    @ApiModelProperty(value = "资产性质")
    @TableField("assetsnature")
    private String assetsnature;

    @ApiModelProperty(value = "设备来源种类")
    @TableField("assetsource")
    private String assetsource;

    @ApiModelProperty(value = "是否组合设备")
    @TableField("combinedequipment")
    private Boolean combinedequipment = false;

    @ApiModelProperty(value = "出厂编号")
    @TableField("factorynumber")
    private String factorynumber;

    @ApiModelProperty(value = "制造国家")
    @TableField("manufacturecountry")
    private String manufacturecountry;

    @ApiModelProperty(value = "经营方式")
    @TableField("operationmodel")
    private String operationmodel;

    @ApiModelProperty(value = "运行编号")
    @TableField("operationno")
    private String operationno;

    @ApiModelProperty(value = "验收测试的信息")
    @TableField("acceptancetest")
    private String acceptancetest;

    @ApiModelProperty(value = "基线状态")
    @TableField("baselinecondition")
    private String baselinecondition;

    @ApiModelProperty(value = "基线生命损耗")
    @TableField("baselinelossoflife")
    private String baselinelossoflife;

    @ApiModelProperty(value = "重要性")
    @TableField("critical")
    private Boolean critical = false;

    @ApiModelProperty(value = "电子地址")
    @TableField("electronicaddress")
    private String electronicaddress;

    @ApiModelProperty(value = "资产生命周期日期")
    @TableField("lifecycledate")
    private String lifecycledate;

    @ApiModelProperty(value = "资产生命周期状态")
    @TableField("lifecyclestate")
    private String lifecyclestate;

    @ApiModelProperty(value = "批号")
    @TableField("lotnumber")
    private String lotnumber;

    @ApiModelProperty(value = "采购价格")
    @TableField("purchaseprice")
    private String purchaseprice;

    @ApiModelProperty(value = "退役原因")
    @TableField("retiredreason")
    private String retiredreason;

    @ApiModelProperty(value = "编号")
    @TableField("serialnumber")
    private String serialnumber;

    @ApiModelProperty(value = "类型")
    @TableField("type")
    private String type;

    @ApiModelProperty(value = "UTC编号")
    @TableField("utcnumber")
    private String utcnumber;

    @ApiModelProperty(value = "所关联的设备信息")
    @TableField("fireequipmentinfo")
    private String fireequipmentinfo;

}