package com.yeejoin.equipmanage.service.impl;

import com.yeejoin.equipmanage.common.enums.ConfigPageTopicEnum;
import com.yeejoin.equipmanage.listener.IntegratePageDataListener;
import com.yeejoin.equipmanage.service.IMaintenanceResourceDataService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.component.emq.EmqKeeper;

/**
 * @author keyong
 * @title: ApplicationRunnerImpl
 * <pre>
 * @description: TODO
 * </pre>
 * @date 2020/12/12 20:18
 */
@Component
public class ApplicationRunnerImpl implements ApplicationRunner {

    @Autowired
    private IMaintenanceResourceDataService maintenanceResourceDataService;

    @Autowired
    private EmqKeeper emqKeeper;

    @Autowired
    IntegratePageDataListener integratePageDataListener;

    @Override
    public void run(ApplicationArguments args) throws Exception {
        maintenanceResourceDataService.subscribeTopic();
        emqKeeper.getMqttClient().subscribe(ConfigPageTopicEnum.INTEGRATE.getTopic(),2, integratePageDataListener);
    }
}
