package com.yeejoin.amos.supervision.business.feign;

import com.yeejoin.amos.component.feign.model.FeignClientResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @author DELL
 */
@FeignClient(name = "${jcs.fegin.name}",configuration = FeignConfiguration.class)
public interface JCSFeignClient {

    /**
     * 查询用户单位信息
     * @param userId 用户id
     * @return ResponseModel<ReginParams.PersonIdentity>
     */
    @GetMapping(value = "jcs/org-usr/getLoginUserDetails/{userId}")
    FeignClientResult getUserUnit(@PathVariable String userId);

    /**
     * 查询所有未同步的机场单位
     * @return ResponseModel
     */
    @GetMapping(value = "jcs/org-usr/unSync/orgCompany")
    FeignClientResult getUnSyncOrgCompanyList(@RequestParam List<Long> companyIdList);

    /**
     * 根据机场人员id批量获取amos平台人员id
     *
     * @param orgUserIds 机场单位人员id
     * @return
     */
    @RequestMapping(value = "jcs/org-usr/amos/orgUserIds", method = RequestMethod.GET)
    FeignClientResult getAmosIdListByUserIds(@RequestParam String orgUserIds);

    /**
     * 根据机场单位id批量获取各单位下的部门数量
     *
     * @param companyIdList 机场单位人员id
     * @return
     */
    @RequestMapping(value = "jcs/org-usr/amos/companyIds", method = RequestMethod.GET)
    FeignClientResult<Map<String, Integer>> getDeptCountByCompanyIds(@RequestParam("companyIdList") List<String> companyIdList);

    /**
     * 根据机场单位id获取单位详情
     *
     * @param companyId 机场单位id
     * @return
     */
    @RequestMapping(value = "jcs/org-usr/getUnit/{id}", method = RequestMethod.GET)
    FeignClientResult<Map<String, Object>> getCompanyById(@PathVariable("id") String companyId);
}
