package com.yeejoin.amos.boot.module.ugp.api.dto;

import com.yeejoin.amos.boot.module.ugp.api.entity.Company;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 企业信息表
 *
 * @author system_generator
 * @date 2022-09-22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="CompanyDto", description="企业信息表")
public class CompanyDto  extends BaseDto {

   private static final long serialVersionUID = 1L;

   Company company;


    @ApiModelProperty(value = "企业名称")
    private String name;

    @ApiModelProperty(value = "企业类型")
    private String type;

    @ApiModelProperty(value = "统一信用代码")
    private String creditCode;

    @ApiModelProperty(value = "许可证号")
    private String licenseNumber;

    @ApiModelProperty(value = "有效期至")
    private Date expirationDate;

    @ApiModelProperty(value = "企业地址")
    private String address;

    @ApiModelProperty(value = "联系方式")
    private String contactPhone;

    @ApiModelProperty(value = "联系人")
    private String contact;

    private String remark;

    @ApiModelProperty(value = "统一信用代码证书附件")
    private String creditAttch;

    @ApiModelProperty(value = "许可证附件")
    private String licenseAttch;

    @ApiModelProperty(value = "是否已审核（1已审核，0未审核）")
    private String approved;

    @ApiModelProperty(value = "单位机构代码")
    private String orgCode;

}
