package com.yeejoin.amos.boot.module.ugp.biz.controller;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.biz.common.constants.CommonConstant;
import com.yeejoin.amos.boot.module.common.api.dto.OrgUsrDto;
import com.yeejoin.amos.boot.module.common.api.service.IOrgUsrService;
import com.yeejoin.amos.boot.module.common.biz.service.impl.OrgUsrServiceImpl;
import com.yeejoin.amos.boot.module.ugp.api.entity.Company;
import com.yeejoin.amos.boot.module.ugp.api.mapper.CompanyMapper;
import com.yeejoin.amos.boot.module.ugp.biz.service.impl.OrgServiceImpl;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import com.yeejoin.amos.feign.privilege.util.DesUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;


import java.util.*;

import com.yeejoin.amos.boot.module.ugp.biz.service.impl.CompanyServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.ugp.api.dto.CompanyDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 企业信息表
 *
 * @author system_generator
 * @date 2022-09-22
 */
@RestController
@Api(tags = "企业信息表Api")
@RequestMapping(value = "/company")
public class CompanyController extends BaseController {

    @Autowired
    CompanyServiceImpl companyServiceImpl;
	@Autowired(required = false)
	CompanyMapper companyMapper;
	@Autowired
	OrgUsrServiceImpl iOrgUsrService;
	@Autowired
	OrgServiceImpl orgServiceImpl;

	@Value("${amos.secret.key}")
	String secretKey;

    /**
     * 新增企业信息表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增企业信息表", notes = "新增企业信息表")
	public ResponseModel<CompanyDto> save(@RequestBody CompanyDto model) {
	    model = companyServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新企业信息表", notes = "根据sequenceNbr更新企业信息表")
	public ResponseModel<CompanyDto> updateBySequenceNbrCompany(@RequestBody CompanyDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(companyServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除企业信息表", notes = "根据sequenceNbr删除企业信息表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(companyServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个企业信息表",  notes = "根据sequenceNbr查询单个企业信息表")
	public ResponseModel<CompanyDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(companyServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "企业信息表分页查询",  notes = "企业信息表分页查询")
	public ResponseModel<Page<CompanyDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<CompanyDto> page = new Page<CompanyDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(companyServiceImpl.queryForCompanyPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "企业信息表列表全部数据查询",   notes = "企业信息表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<CompanyDto>> selectForList() {
	    return ResponseHelper.buildResponse(companyServiceImpl.queryForCompanyList());
	}
	/**
	 * 修改企业信息
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@ApiOperation(httpMethod = "Post",value = "修改企业信息",   notes = "修改企业信息")
	@PostMapping(value = "/modifyCompanyInfo")
	public ResponseModel<String> modifyCompanyInfo(@RequestBody CompanyDto company) throws Exception {



		companyServiceImpl.updateById(company.getCompany());

		return ResponseHelper.buildResponse("ok");


	}
	/**
	 * 查看企业信息详情
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET",value = "查看企业信息详情",   notes = "查看企业信息详情")
	@GetMapping(value = "/getCompanyInfo")
	public ResponseModel<Company> getCompanyInfo(Company companyList)  {
//		Company company;
//		QueryWrapper<Company> lambdaQueryWrapper=new QueryWrapper<>();
//		lambdaQueryWrapper.eq("name",companyList.getName());
//		company= companyMapper.selectOne(lambdaQueryWrapper);


		return ResponseHelper.buildResponse(companyMapper.selectById(companyList));


	}
	/**
	 * 企业审核
	 * 根据sequenceNbr更新，审核通过后的企业调用平台接口创建单位及管理员，并存业务的cb_org_usr表
	 * @param sequenceNbr 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@PostMapping(value = "check")
	@ApiOperation(httpMethod = "POST", value = "根据sequenceNbr更新，并创建单位及管理员", notes = "根据sequenceNbr更新，并创建单位及管理员")
	public ResponseModel<Boolean> companyCheck(@RequestBody CompanyDto model,Long sequenceNbr,String bizOrgType) throws Exception{

		Company company = companyServiceImpl.getById(sequenceNbr);
		company.setApproved(model.getApproved());

		if (company.getApproved().equals("已审核")){
			final CompanyModel companyModel = new CompanyModel();
			final AgencyUserModel agencyUserModel = new AgencyUserModel();

			//创建平台企业
			companyModel.setCompanyName(company.getName());
			companyModel.setCompanyCode(company.getCreditCode());
			companyModel.setAddress(company.getAddress());
			companyModel.setParentId(0L);
			companyModel.setLevel("headquarter");
			companyModel.setAgencyCode("ugp");
			final CompanyModel companyModelFeignClient = Privilege.companyClient.create(companyModel).getResult();

			//创建平台用户
			String admin = company.getAdmin();
			String adminPhone = company.getAdminPhone();
			agencyUserModel.setRealName(admin);
			agencyUserModel.setMobile(company.getContactPhone());
			agencyUserModel.setAgencyCode("ugp");
			agencyUserModel.setLockStatus("UNLOCK");
			agencyUserModel.setMobile(adminPhone);
			agencyUserModel.setCreateTime(new Date());
			agencyUserModel.setUserName(admin);
			agencyUserModel.setPassword(DesUtil.encode(adminPhone, secretKey));
			agencyUserModel.setRePassword(DesUtil.encode(adminPhone, secretKey));
			Privilege.agencyUserClient.create(agencyUserModel);

			//企业动态表单存储
			JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(company));
			jsonObject.put("amosOrgId",companyModelFeignClient.getSequenceNbr());
			jsonObject.put("amosOrgCode",companyModelFeignClient.getOrgCode());
			orgServiceImpl.dataHandling(jsonObject,bizOrgType,null);

		}
		return ResponseHelper.buildResponse(companyServiceImpl.updateById(company));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@PostMapping(value = "test")
	@ApiOperation(httpMethod = "Post", value = "根据sequenceNbr更新，并创建单位及管理员", notes = "根据sequenceNbr更新，并创建单位及管理员")
	public ResponseModel<OrgUsrDto> getInfo(@RequestBody JSONObject jsonObject, String bizOrgType,String sequenceNbr){
		return ResponseHelper.buildResponse(orgServiceImpl.dataHandling(jsonObject,bizOrgType,sequenceNbr));
	}
}

