package com.yeejoin.amos.boot.module.ugp.biz.controller;

import com.alibaba.fastjson.JSONObject;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.ugp.biz.service.impl.MaterialServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.ugp.api.dto.MaterialDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 材料信息表
 *
 * @author system_generator
 * @date 2022-09-22
 */
@RestController
@Api(tags = "材料信息表Api")
@RequestMapping(value = "/material")
public class MaterialController extends BaseController {

    @Autowired
    MaterialServiceImpl materialServiceImpl;

    /**
     * 新增材料信息表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增材料信息表", notes = "新增材料信息表")
	public ResponseModel<MaterialDto> save(@RequestBody MaterialDto model) {
	    model = materialServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新材料信息表", notes = "根据sequenceNbr更新材料信息表")
	public ResponseModel<MaterialDto> updateBySequenceNbrMaterial(@RequestBody MaterialDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(materialServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除材料信息表", notes = "根据sequenceNbr删除材料信息表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(materialServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个材料信息表",  notes = "根据sequenceNbr查询单个材料信息表")
	public ResponseModel<MaterialDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(materialServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "材料信息表分页查询",  notes = "材料信息表分页查询")
	public ResponseModel<Page<MaterialDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<MaterialDto> page = new Page<MaterialDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(materialServiceImpl.queryForMaterialPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "材料信息表列表全部数据查询",   notes = "材料信息表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<MaterialDto>> selectForList() {
	    return ResponseHelper.buildResponse(materialServiceImpl.queryForMaterialList());
	}


//	/**
//     * 根据项目id查询材料信息
//     *
//     * @return
//     */
//	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
//	@ApiOperation(httpMethod = "GET",value = "根据项目id查询材料信息",   notes = "根据项目id查询材料信息")
//	@GetMapping(value = "/selectMess")
//	public ResponseModel<MaterialDto> selectMess(@RequestParam String companyId ) {
//		return ResponseHelper.buildResponse(materialServiceImpl.selectMess(companyId));
//	}

	/**
	 * 材料信息表列表全部数据查询
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@ApiOperation(httpMethod = "GET",value = "材料信息表列表全部数据查询",   notes = "材料信息表列表全部数据查询")
	@GetMapping(value = "/selectName")
	public ResponseModel<List<JSONObject>> selectName() {
		return ResponseHelper.buildResponse(materialServiceImpl.selectName());
	}
}
