package com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.vehicleInformation;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.common.biz.event.CommonPublisher;
import com.yeejoin.amos.boot.module.jg.api.dto.FieldChangeMeta;
import com.yeejoin.amos.boot.module.jg.api.dto.PipelineChangeItemDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgVehicleInformation;
import com.yeejoin.amos.boot.module.jg.api.enums.BusinessTypeEnum;
import com.yeejoin.amos.boot.module.jg.biz.edit.event.BaseBizDataChangeEvent;
import com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.DefaultBizDataChangeHandler;
import com.yeejoin.amos.boot.module.ymt.api.enums.FlowStatusEnum;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 车用气瓶登记编辑处理器
 */
@Component
public class VehicleInformationDataChangeHandler extends DefaultBizDataChangeHandler<BaseBizDataChangeEvent> {

    private final VehicleInformationEditUpdateService vehicleInformationEditUpdateService;

    protected VehicleInformationDataChangeHandler(CommonPublisher routerEventPublisher, ApplicationContext applicationContext, VehicleInformationEditUpdateService vehicleInformationEditUpdateService) {
        super(routerEventPublisher, applicationContext);
        this.vehicleInformationEditUpdateService = vehicleInformationEditUpdateService;
    }

    @Override
    public String canHandleBizType() {
        return BusinessTypeEnum.JG_VEHICLE_GAS_APPLICATION.name();
    }

    @Override
    public List<FieldChangeMeta> postSave(String bizId, String applyNo, ModelType model, Map<String, Object> changeData, List<FieldChangeMeta> allChangeColumns, Map<String, List<PipelineChangeItemDto>> pipelineChangeItemMap) {
        return Collections.emptyList();
    }

    @Override
    public Boolean beforeCheck(String bizId, String applyNo, ModelType model, Map<String, Object> changeData) {
        return Boolean.TRUE;
    }

    @Override
    public Set<String> getEqs(String applyNo) {
        return vehicleInformationEditUpdateService.getEqsByApplyNo(applyNo);
    }

    /**
     * 管道专用
     * @param applyNo 单据号
     * 判断数据是实时落库，还是先存到json
     * @return 是否需要临时存储
     */
    @Override
    public Boolean requiresTemporarySave(String applyNo) {
        return false;
    }

    @Override
    public Boolean bizIsFinished(String applyNo) {
        JgVehicleInformation jgVehicleInformation = vehicleInformationEditUpdateService.getMainService().getOne(new LambdaQueryWrapper<JgVehicleInformation>().eq(JgVehicleInformation::getApplyNo, applyNo).select(BaseEntity::getSequenceNbr, JgVehicleInformation::getStatus));
        return jgVehicleInformation.getStatus().equals(FlowStatusEnum.TO_BE_FINISHED.getName());
    }

    @Override
    public Set<String> getProjectContraptionIds(String applyNo) {
        return Collections.emptySet();
    }

    @Override
    public void preSave(String bizId, String applyNo, ModelType model, Map<String, Object> changeData) {

    }
}
