package com.yeejoin.amos.boot.module.ymt.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 单位注册许可信息表
 *
 * @author system_generator
 * @date 2022-08-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_base_unit_licence")
public class BaseUnitLicence extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 单位编码
     */
	@TableField("unit_code")
    private String unitCode;

    /**
     * 单位名称
     */
	@TableField("unit_name")
    private String unitName;

    /**
     * 许可地址
     */
	@TableField("lic_address")
    private String licAddress;

    /**
     * 证书类型
     */
	@TableField("cert_type")
    private String certType;


    /**
     * 证书类型code
     */
    @TableField("cert_type_code")
    private String certTypeCode;

    /**
     * 证书编号
     */
	@TableField("cert_no")
    private String certNo;

    /**
     * 有效期至
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
	@TableField("expiry_date")
    private Date expiryDate;

    /**
     * 发证日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
	@TableField("issue_date")
    private Date issueDate;

    /**
     * 变更日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
	@TableField("change_date")
    private Date changeDate;

    /**
     * 许可方式/许可状态
     */
	@TableField("apply_type")
    private String applyType;

    /**
     * 许可方式/许可状态
     */
    @TableField("apply_type_code")
    private String applyTypeCode;


    /**
     * 许可评审方式
     */
    private String appraisalType;

    /**
     * 许可评审方式code
     */
    private String appraisalTypeCode;

    /**
     * 备注
     */
	@TableField("remark")
    private String remark;

    /**
     * 许可项目/检验类型/设备品种编码
     */
	@TableField("item_code")
    private String itemCode;

    /**
     * 许可项目/检验类型/设备品种
     */
	@TableField("item_code_name")
    private String itemCodeName;

    /**
     * 许可子项目/检验项目/充装介质类别code
     */
	@TableField("sub_item_code")
    private String subItemCode;

    /**
     * 许可子项目/检验项目/充装介质类别
     */
	@TableField("sub_item_name")
    private String subItemName;

    /**
     * 许可参数/充装介质名称
     */
	@TableField("parameter")
    private String parameter;


    /**
     * 许可参数/充装介质code
     */
    @TableField("parameter_code")
    private String parameterCode;

    /**
     * 固定检验地址
     */
	@TableField("item_address")
    private String itemAddress;

    /**
     * 发证机关
     */
	private String approvedOrgan;

    /**
     * 发证机关code
     */
	private String approvedOrganCode;

    /**
     * 是否同步自许可（1是 0否）
     */
    @TableField("is_not_sync")
    private String isNotSync;

    /**
     * 机构类别枚举
     */
    private String agencyType;

    /**
     * 机构类别枚举名称，冗余
     */
    private String agencyTypeName;

    /**
     * 资质类型编码（检验检测、其他）
     */
    private String licenceType;

    /**
     * 所属证书ID
     */
    @TableField("enterprise_cert_seq")
    private String enterpriseCertSeq;

    /**
     * 字典表id
     */
    @TableField("dict_seq")
    private Long dictSeq;

    /**
     * 企业资质证书照片
     */
    @TableField("qualification_certificate_attachment")
    private String qualificationCertificateAttachment;

    /**
     *  企业资质状态：报检预留字段，如启用、停用、超期等
     */
    @TableField("licence_state")
    private Integer licenceState;

}
