package com.yeejoin.equipmanage.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.equipmanage.common.utils.CommonResponseUtil;
import com.yeejoin.equipmanage.service.IEmergencyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Map;

/**
 *
 * 四横八纵应急模块接口
 *
 *
 */
@RestController
@Api(tags = "四横八纵应急模块Api")
@RequestMapping(value = "/emergency", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class EmergencyController extends AbstractBaseController {

    @Autowired
	IEmergencyService iEmergencyService;

	/**
	 * 通过bizOrgCode过滤
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation("系统状态")
	@GetMapping(value = "/system/state")
	public ResponseModel getSystemState() {
        ReginParams reginParams = getSelectedOrgInfo();
        String bizOrgCode = reginParams.getPersonIdentity().getBizOrgCode();
		return CommonResponseUtil.success(iEmergencyService.getSystemState(bizOrgCode));
	}

	/**
	 * CAFS-消防水箱信息
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation("CAFS-消防水箱信息")
	@GetMapping(value = "/cafs-tank")
	public ResponseModel getCAFSWaterTankInfo() {
		ReginParams reginParams = getSelectedOrgInfo();
		String bizOrgCode = reginParams.getPersonIdentity().getBizOrgCode();
		return CommonResponseUtil.success(iEmergencyService.getCAFSWaterTankInfo(bizOrgCode));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation("应急物资")
	@GetMapping(value = "/emergencyMaterials")
	public Map<String, Object> emergencyMaterials(@RequestParam(value = "bizOrgCode", required = false) String bizOrgCode )  {
		if (ObjectUtils.isEmpty(bizOrgCode)){
			ReginParams reginParams = getSelectedOrgInfo();
			bizOrgCode = reginParams.getPersonIdentity().getBizOrgCode();
		}
		return iEmergencyService.emergencyMaterials(bizOrgCode);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation("应急物资-详情")
	@GetMapping(value = "/emergencyMaterialsDetails")
	public Page<Map<String, Object>> emergencyMaterialsDetails(@RequestParam(value = "bizOrgCode", required = false) String bizOrgCode ,
															   @RequestParam(value = "pageNumber") int pageNumber,
															   @RequestParam(value = "pageSize") int pageSize)  {
		Page<Map<String, Object>> page = new Page<>(pageNumber, pageSize);
		if (ObjectUtils.isEmpty(bizOrgCode)){
			ReginParams reginParams = getSelectedOrgInfo();
			bizOrgCode = reginParams.getPersonIdentity().getBizOrgCode();
		}
		return iEmergencyService.emergencyMaterialsDetails(page, bizOrgCode);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation("消防炮列表")
	@GetMapping(value = "/fireMonitor")
	public Page<Map<String, Object>> selectFireMonitor(@RequestParam(value = "bizOrgCode", required = false) String bizOrgCode,
													   @RequestParam(value = "pageNumber") int pageNumber,
													   @RequestParam(value = "pageSize") int pageSize,
													   @RequestParam(value = "code") String code)  {
		Page<Map<String, Object>> page = new Page<>(pageNumber, pageSize);
		if (ObjectUtils.isEmpty(bizOrgCode)){
			ReginParams reginParams = getSelectedOrgInfo();
			bizOrgCode = reginParams.getPersonIdentity().getBizOrgCode();
		}
		return iEmergencyService.selectFireMonitor(page, bizOrgCode, code);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation("泡沫罐列表")
	@GetMapping(value = "/selectFoamTank")
	public Page<Map<String, Object>> selectFoamTank(@RequestParam(value = "bizOrgCode", required = false) String bizOrgCode,
													@RequestParam(value = "pageNumber") int pageNumber,
													@RequestParam(value = "pageSize") int pageSize
													)  {
		Page<Map<String, Object>> page = new Page<>(pageNumber, pageSize);
		if (ObjectUtils.isEmpty(bizOrgCode)){
			ReginParams reginParams = getSelectedOrgInfo();
			bizOrgCode = reginParams.getPersonIdentity().getBizOrgCode();
		}
		return iEmergencyService.selectFoamTank(page, bizOrgCode);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation("排油系统列表")
	@GetMapping(value = "/selectOilDrainage")
	public Page<Map<String, Object>> selectOilDrainage(@RequestParam(value = "bizOrgCode", required = false) String bizOrgCode ,
													   @RequestParam(value = "pageNumber") int pageNumber,
													   @RequestParam(value = "pageSize") int pageSize,
													   @RequestParam(value = "code") String code)  {
		Page<Map<String, Object>> page = new Page<>(pageNumber, pageSize);
		if (ObjectUtils.isEmpty(bizOrgCode)){
			ReginParams reginParams = getSelectedOrgInfo();
			bizOrgCode = reginParams.getPersonIdentity().getBizOrgCode();
		}
		return iEmergencyService.selectOilDrainage(page, bizOrgCode, code);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation("压力流量")
	@GetMapping(value = "/selectPressureFlow")
	public Page<Map<String, Object>> selectPressureFlow(@RequestParam(value = "bizOrgCode", required = false) String bizOrgCode ,
													   @RequestParam(value = "pageNumber") int pageNumber,
													   @RequestParam(value = "pageSize") int pageSize)  {
		Page<Map<String, Object>> page = new Page<>(pageNumber, pageSize);
		if (ObjectUtils.isEmpty(bizOrgCode)){
			ReginParams reginParams = getSelectedOrgInfo();
			bizOrgCode = reginParams.getPersonIdentity().getBizOrgCode();
		}
		return iEmergencyService.selectPressureFlow(page, bizOrgCode);
	}

}
