package com.yeejoin.amos.boot.module.jg.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.EquipClaimServiceImpl;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgProjectContraption;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Map;

@Api(tags = "设备认领")
@RestController
@RequestMapping(value = "/equipClaim")
@RequiredArgsConstructor
public class EquipClaimController extends BaseController {

    private final EquipClaimServiceImpl equipClaimService;

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/setEquip/page")
    @ApiOperation(value = "待认领-台套设备分页", httpMethod = "GET")
    public ResponseModel<Page<JSONObject>> setEquipPage(@RequestParam Map<String, Object> map) {
        return ResponseHelper.buildResponse(equipClaimService.setEquipPage(new JSONObject(map)));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/setEquip/claim")
    @ApiOperation(value = "认领-台套设备", httpMethod = "POST")
    public ResponseModel<Object> setEquipClaim(@RequestBody Map<String, Object> map) {
        return ResponseHelper.buildResponse(equipClaimService.setEquipClaim(new JSONObject(map)));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/pipeEquip/page")
    @ApiOperation(value = "待认领-管道装置设备分页", httpMethod = "GET")
    public ResponseModel<IPage<IdxBizJgProjectContraption>> pipeEquipPage(@RequestParam Map<String, Object> map) {
        return ResponseHelper.buildResponse(equipClaimService.pipeEquipPage(new JSONObject(map)));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/pipeEquip/claim")
    @ApiOperation(value = "认领-管道设备", httpMethod = "POST")
    public ResponseModel<Object> pipeEquipClaim(@RequestBody Map<String, Object> map) {
        return ResponseHelper.buildResponse(equipClaimService.pipeEquipClaim(new JSONObject(map)));
    }

}
