package com.yeejoin.precontrol.common.enums;

/**
 * @Description: 人员类型枚举
 * @Author: duanwei
 * @Date: 2020/10/29
 */
public enum TaskTypeEnum {

	/**
	 * 技术交底
	 */
	JOBDISCLOSURE("工程交底", 0L),
	/**
	 * 三交三查
	 */
	TASKPAYCHECK("三交三查", 1L),
	/**
	 * 违规任务
	 */
	BAD("违规管理", 2L),
	/**
	 * 风险作业
	 */
	RISK("风险作业", 3L),
	/**
	 * 安全施工作业票
	 */
	TICKET("安全施工作业票", 4L),
	/**
	 * 安全施工作业票
	 */
	SALARY_CONFIRM("薪资确认", 5L),
	/**
	 * 知识分享
	 */
	KNOWLEDGE_SHARE("知识推送", 6L),
	
	/**
	 * 技术交底(风险作业)
	 */
	TECH_DISCLOSURE(" 技术交底", 7L);

	private String label;
	private Long value;

	TaskTypeEnum(String label, Long value) {
		this.label = label;
		this.value = value;
	}

	public String getLabel() {
		return label;
	}

	public void setLabel(String label) {
		this.label = label;
	}

	public Long getValue() {
		return value;
	}

	public void setValue(Long value) {
		this.value = value;
	}

	public static String getLabelByValue(Long value) {
		String label = null;
		for (TaskTypeEnum type : TaskTypeEnum.values()) {
			if (type.getValue().equals(value)) {
				label = type.getLabel();
				break;
			}
		}
		return label;
	}
}
