package com.yeejoin.precontrol.common.enums;

public enum TypeKeyEnum {
	
	COMPANY(0, "分包商"),
	
	JXDJ(1, "江西电建");

	private int type;

	private String name;

	TypeKeyEnum(int type, String name) {
		this.type = type;
		this.name = name;
	}

	public int getType() {
		return type;
	}

	public long getLongType() {
		return Long.valueOf(type);
	}

	public String getName() {
		return name;
	}

	public static String getNameByType(Long type) {
		String name = null;
		for (TypeKeyEnum enumOne : TypeKeyEnum.values()) {
			if (enumOne.getType() == type) {
				name = enumOne.getName();
				break;
			}
		}
		return name;
	}
}
